/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_5699;

public class FactorCalculationData {
    public static final Codec<FactorCalculationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("padding_duration").forGetter(data -> data.paddingDuration), (App)Codec.FLOAT.fieldOf("factor_start").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.factorStart)), (App)Codec.FLOAT.fieldOf("factor_target").orElse((Object)Float.valueOf(1.0f)).forGetter(data -> Float.valueOf(data.factorTarget)), (App)Codec.FLOAT.fieldOf("factor_current").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.factorCurrent)), (App)class_5699.field_33441.fieldOf("effect_changed_timestamp").orElse((Object)0).forGetter(data -> data.effectChangedTimestamp), (App)Codec.FLOAT.fieldOf("factor_previous_frame").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.factorPreviousFrame)), (App)Codec.BOOL.fieldOf("had_effect_last_tick").orElse((Object)false).forGetter(data -> data.hadEffectLastTick)).apply((Applicative)instance, FactorCalculationData::new));
    private final int paddingDuration;
    private float factorStart;
    private float factorTarget;
    private float factorCurrent;
    public int effectChangedTimestamp;
    private float factorPreviousFrame;
    private boolean hadEffectLastTick;

    public FactorCalculationData(int paddingDuration, float factorStart, float factorTarget, float factorCurrent, int effectChangedTimestamp, float factorPreviousFrame, boolean hadEffectLastTick) {
        this.paddingDuration = paddingDuration;
        this.factorStart = factorStart;
        this.factorTarget = factorTarget;
        this.factorCurrent = factorCurrent;
        this.effectChangedTimestamp = effectChangedTimestamp;
        this.factorPreviousFrame = factorPreviousFrame;
        this.hadEffectLastTick = hadEffectLastTick;
    }

    public FactorCalculationData(int paddingDuration) {
        this(paddingDuration, 0.0f, 1.0f, 0.0f, 0, 0.0f, false);
    }

    public void update(class_1293 instance) {
        boolean inRange;
        this.factorPreviousFrame = this.factorCurrent;
        boolean bl = inRange = instance.method_5584() > this.paddingDuration;
        if (this.hadEffectLastTick != inRange) {
            this.hadEffectLastTick = inRange;
            this.effectChangedTimestamp = instance.method_5584();
            this.factorStart = this.factorCurrent;
            this.factorTarget = inRange ? 1.0f : 0.0f;
        }
        float delta = class_3532.method_15363((float)(((float)this.effectChangedTimestamp - (float)instance.method_5584()) / (float)this.paddingDuration), (float)0.0f, (float)1.0f);
        this.factorCurrent = class_3532.method_16439((float)delta, (float)this.factorCurrent, (float)this.factorTarget);
    }

    public float lerp(class_1309 entity, float factor) {
        if (entity.method_31481()) {
            this.factorPreviousFrame = this.factorCurrent;
        }
        return class_3532.method_16439((float)factor, (float)this.factorPreviousFrame, (float)this.factorCurrent);
    }
}

