/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities;

import com.cursedcauldron.wildbackport.client.animation.api.AnimationState;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.access.api.Poses;
import com.cursedcauldron.wildbackport.common.entities.brain.FrogBrain;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.registry.entity.WBSensorTypes;
import com.cursedcauldron.wildbackport.common.tag.WBBiomeTags;
import com.cursedcauldron.wildbackport.common.tag.WBBlockTags;
import com.cursedcauldron.wildbackport.common.tag.WBEntityTypeTags;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1333;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1429;
import net.minecraft.class_15;
import net.minecraft.class_1621;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class Frog
extends class_1429 {
    public static final class_1856 FOOD = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8777});
    protected static final ImmutableList<? extends class_4149<? extends class_4148<? super Frog>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, WBSensorTypes.FROG_ATTACKABLES.get(), WBSensorTypes.FROG_TEMPTATIONS.get(), WBSensorTypes.IS_IN_WATER.get());
    protected static final ImmutableList<? extends class_4140<?>> MEMORIES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18448, (Object)class_4140.field_30244, (Object)class_4140.field_30245, (Object)class_4140.field_22355, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object[])new class_4140[]{class_4140.field_28327, class_4140.field_18451, class_4140.field_18452, class_4140.field_30243, WBMemoryModules.IS_IN_WATER.get(), WBMemoryModules.IS_PREGNANT.get(), WBMemoryModules.UNREACHABLE_TONGUE_TARGETS.get()});
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(Frog.class, (class_2941)class_2943.field_13327);
    private static final class_2940<OptionalInt> TARGET = class_2945.method_12791(Frog.class, (class_2941)class_2943.field_17910);
    public final AnimationState longJumpingAnimationState = new AnimationState();
    public final AnimationState croakingAnimationState = new AnimationState();
    public final AnimationState usingTongueAnimationState = new AnimationState();
    public final AnimationState walkingAnimationState = new AnimationState();
    public final AnimationState swimmingAnimationState = new AnimationState();
    public final AnimationState idlingInWaterAnimationState = new AnimationState();

    public Frog(class_1299<? extends class_1429> type, class_1937 level) {
        super(type, level);
        this.field_6206 = new FrogLookController((class_1308)this);
        this.method_5941(class_7.field_18, 4.0f);
        this.method_5941(class_7.field_19, -1.0f);
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
        this.field_6013 = 1.0f;
    }

    protected class_4095.class_5303<Frog> method_28306() {
        return class_4095.method_28311(MEMORIES, SENSORS);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return FrogBrain.create((class_4095<Frog>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Frog> method_18868() {
        return super.method_18868();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(TARGET, (Object)OptionalInt.empty());
    }

    public void clearFrogTarget() {
        this.field_6011.method_12778(TARGET, (Object)OptionalInt.empty());
    }

    public Optional<class_1297> getFrogTarget() {
        return ((OptionalInt)this.field_6011.method_12789(TARGET)).stream().mapToObj(arg_0 -> ((class_1937)this.field_6002).method_8469(arg_0)).filter(Objects::nonNull).findFirst();
    }

    public void setFrogTarget(class_1297 entity) {
        this.field_6011.method_12778(TARGET, (Object)OptionalInt.of(entity.method_5628()));
    }

    public int method_20240() {
        return 35;
    }

    public int method_5986() {
        return 5;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant().getId());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setVariant(Variant.byId(tag.method_10550("Variant")));
    }

    public boolean method_6094() {
        return true;
    }

    private boolean shouldWalk() {
        return this.field_5952 && this.method_18798().method_37268() > 1.0E-6 && !this.method_5816();
    }

    private boolean shouldSwim() {
        return this.method_18798().method_37268() > 1.0E-6 && this.method_5816();
    }

    protected void method_5958() {
        this.field_6002.method_16107().method_15396("frogBrain");
        this.method_18868().method_19542((class_3218)this.field_6002, (class_1309)this);
        this.field_6002.method_16107().method_15407();
        this.field_6002.method_16107().method_15396("frogActivityUpdate");
        FrogBrain.updateActivities(this);
        this.field_6002.method_16107().method_15407();
        super.method_5958();
    }

    public void method_5773() {
        if (this.field_6002.method_8608()) {
            if (this.shouldWalk()) {
                this.walkingAnimationState.startIfNotRunning(this.field_6012);
            } else {
                this.walkingAnimationState.stop();
            }
            if (this.shouldSwim()) {
                this.idlingInWaterAnimationState.stop();
                this.swimmingAnimationState.startIfNotRunning(this.field_6012);
            } else if (this.method_5816()) {
                this.swimmingAnimationState.stop();
                this.idlingInWaterAnimationState.startIfNotRunning(this.field_6012);
            } else {
                this.swimmingAnimationState.stop();
                this.idlingInWaterAnimationState.stop();
            }
        }
        super.method_5773();
    }

    public void method_5674(class_2940<?> data) {
        if (field_18064.equals(data)) {
            if (this.isInPose(class_4050.field_30095)) {
                this.longJumpingAnimationState.start(this.field_6012);
            } else {
                this.longJumpingAnimationState.stop();
            }
            if (this.isInPose(Poses.CROAKING.get())) {
                this.croakingAnimationState.start(this.field_6012);
            } else {
                this.croakingAnimationState.stop();
            }
            if (this.isInPose(Poses.USING_TONGUE.get())) {
                this.usingTongueAnimationState.start(this.field_6012);
            } else {
                this.usingTongueAnimationState.stop();
            }
        }
        super.method_5674(data);
    }

    public boolean isInPose(class_4050 pose) {
        return this.method_18376() == pose;
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        Frog frog = (Frog)WBEntityTypes.FROG.get().method_5883((class_1937)level);
        if (frog != null) {
            FrogBrain.coolDownLongJump(frog, level.method_8409());
        }
        return frog;
    }

    public boolean method_6109() {
        return false;
    }

    public void method_7217(boolean baby) {
    }

    public void method_24650(class_3218 level, class_1429 partner) {
        class_3222 player = this.method_6478();
        if (player == null) {
            player = partner.method_6478();
        }
        if (player != null) {
            player.method_7281(class_3468.field_15410);
            class_174.field_1190.method_855(player, (class_1429)this, partner, null);
        }
        this.method_5614(6000);
        partner.method_5614(6000);
        this.method_6477();
        partner.method_6477();
        this.method_18868().method_18878(WBMemoryModules.IS_PREGNANT.get(), (Object)class_3902.field_17274);
        level.method_8421((class_1297)this, (byte)18);
        if (level.method_8450().method_8355(class_1928.field_19391)) {
            level.method_8649((class_1297)new class_1303((class_1937)level, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().nextInt(7) + 1));
        }
    }

    public class_1315 method_5943(class_5425 accessor, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 groupData, @Nullable class_2487 tag) {
        class_6880 biome = accessor.method_23753(this.method_24515());
        if (biome.method_40220(WBBiomeTags.SPAWNS_COLD_VARIANT_FROGS)) {
            this.setVariant(Variant.COLD);
        } else if (biome.method_40220(WBBiomeTags.SPAWNS_WARM_VARIANT_FROGS)) {
            this.setVariant(Variant.WARM);
        } else {
            this.setVariant(Variant.TEMPERATE);
        }
        FrogBrain.coolDownLongJump(this, accessor.method_8409());
        return super.method_5943(accessor, difficulty, spawnType, groupData, tag);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 1.0).method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23721, 10.0);
    }

    @Nullable
    protected class_3414 method_5994() {
        return WBSoundEvents.FROG_AMBIENT;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return WBSoundEvents.FROG_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return WBSoundEvents.FROG_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(WBSoundEvents.FROG_STEP, 0.15f, 1.0f);
    }

    public boolean method_5675() {
        return false;
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance, damageMultiplier) - 5;
    }

    public void method_6091(class_243 input) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), input);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(input);
        }
    }

    public boolean method_29244(class_7 type) {
        return super.method_29244(type) && type != class_7.field_4;
    }

    public static boolean isValidFrogFood(class_1309 entity) {
        class_1621 slime;
        return (!(entity instanceof class_1621) || (slime = (class_1621)entity).method_7152() == 1) && entity.method_5864().method_20210(WBEntityTypeTags.FROG_FOOD);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FrogPathNavigator(this, level);
    }

    public boolean method_6481(class_1799 stack) {
        return FOOD.method_8093(stack);
    }

    public static boolean checkFrogSpawnRules(class_1299<? extends class_1429> type, class_1936 accessor, class_3730 spawnType, class_2338 pos, Random random) {
        return accessor.method_8320(pos.method_10074()).method_26164(WBBlockTags.FROGS_SPAWNABLE_ON) && Frog.method_39448((class_1920)accessor, (class_2338)pos);
    }

    class FrogLookController
    extends class_1333 {
        FrogLookController(class_1308 mobEntity) {
            super(mobEntity);
        }

        protected boolean method_20433() {
            return Frog.this.getFrogTarget().isEmpty();
        }
    }

    public static enum Variant {
        TEMPERATE(0, "temperate"),
        WARM(1, "warm"),
        COLD(2, "cold");

        private static final Variant[] VARIANTS;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant byId(int id) {
            if (id < 0 || id >= VARIANTS.length) {
                id = 0;
            }
            return VARIANTS[id];
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    static class FrogPathNavigator
    extends class_1412 {
        FrogPathNavigator(Frog frog, class_1937 level) {
            super((class_1308)frog, level);
        }

        protected class_13 method_6336(int range) {
            this.field_6678 = new FrogNodeEvaluator(true);
            this.field_6678.method_15(true);
            return new class_13(this.field_6678, range);
        }

        protected boolean method_6358() {
            return true;
        }

        public boolean method_6333(class_2338 pos) {
            return !this.field_6677.method_8320(pos.method_10074()).method_26215();
        }
    }

    static class FrogNodeEvaluator
    extends class_15 {
        private final class_2338.class_2339 preferredBlock = new class_2338.class_2339();

        public FrogNodeEvaluator(boolean penalizeDeepWater) {
            super(penalizeDeepWater);
        }

        public class_7 method_17(class_1922 getter, int x, int y, int z) {
            this.preferredBlock.method_10103(x, y - 1, z);
            class_2680 state = getter.method_8320((class_2338)this.preferredBlock);
            return state.method_26164(WBBlockTags.FROG_PREFER_JUMP_TO) ? class_7.field_7 : FrogNodeEvaluator.method_23476((class_1922)getter, (class_2338.class_2339)this.preferredBlock.method_10098(class_2350.field_11036));
        }
    }
}

