/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.Frog;
import com.cursedcauldron.wildbackport.common.entities.brain.TadpoleBrain;
import com.cursedcauldron.wildbackport.common.registry.WBItems;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1332;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1422;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_5761;
import org.jetbrains.annotations.Nullable;

public class Tadpole
extends class_1422 {
    public static final int MAX_TADPOLE_AGE = Math.abs(-24000);
    private int age;
    protected static final ImmutableList<class_4149<? extends class_4148<? super Tadpole>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18467, (Object)class_4149.field_18469);
    protected static final ImmutableList<class_4140<?>> MEMORIES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_25359);

    public Tadpole(class_1299<? extends class_1422> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
        this.field_6206 = new class_1332((class_1308)this, 10);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_1412((class_1308)this, level);
    }

    protected class_4095.class_5303<Tadpole> method_28306() {
        return class_4095.method_28311(MEMORIES, SENSORS);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return TadpoleBrain.create((class_4095<Tadpole>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Tadpole> method_18868() {
        return super.method_18868();
    }

    protected class_3414 method_6457() {
        return WBSoundEvents.TADPOLE_FLOP;
    }

    protected void method_5958() {
        this.field_6002.method_16107().method_15396("tadpoleBrain");
        this.method_18868().method_19542((class_3218)this.field_6002, (class_1309)this);
        this.field_6002.method_16107().method_15407();
        this.field_6002.method_16107().method_15396("tadpoleActivityUpdate");
        TadpoleBrain.updateActivities(this);
        this.field_6002.method_16107().method_15407();
        super.method_5958();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 1.0).method_26868(class_5134.field_23716, 6.0);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_6002.field_9236) {
            this.setAge(this.age + 1);
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Age", this.age);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setAge(tag.method_10550("Age"));
    }

    @Nullable
    protected class_3414 method_5994() {
        return null;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return WBSoundEvents.TADPOLE_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return WBSoundEvents.TADPOLE_DEATH;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.isSlimeBall(stack)) {
            this.eatSlimeBall(player, stack);
            return class_1269.method_29236((boolean)this.field_6002.method_8608());
        }
        return class_5761.method_35169((class_1657)player, (class_1268)hand, (class_1309)this).orElse(super.method_5992(player, hand));
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_6453() {
        return true;
    }

    public void method_6454(boolean fromBucket) {
    }

    public void method_6455(class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10569("Age", this.getAge());
    }

    public void method_35170(class_2487 nbt) {
        class_5761.method_35168((class_1308)this, (class_2487)nbt);
        if (nbt.method_10545("Age")) {
            this.setAge(nbt.method_10550("Age"));
        }
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)WBItems.TADPOLE_BUCKET.get());
    }

    public class_3414 method_35171() {
        return WBSoundEvents.BUCKED_FILL_TADPOLE;
    }

    private boolean isSlimeBall(class_1799 stack) {
        return Frog.FOOD.method_8093(stack);
    }

    private void eatSlimeBall(class_1657 player, class_1799 stack) {
        this.decrementItem(player, stack);
        this.increaseAge((int)((float)(this.getTicksUntilGrowth() / 20) * 0.1f));
        this.field_6002.method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
    }

    private void decrementItem(class_1657 player, class_1799 stack) {
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
    }

    private int getAge() {
        return this.age;
    }

    private void increaseAge(int seconds) {
        this.setAge(this.age + seconds * 20);
    }

    private void setAge(int age) {
        this.age = age;
        if (this.age >= MAX_TADPOLE_AGE) {
            this.growUp();
        }
    }

    private void growUp() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            Frog frog = (Frog)WBEntityTypes.FROG.get().method_5883(this.field_6002);
            if (frog == null) {
                return;
            }
            frog.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            frog.method_5943((class_5425)server, this.field_6002.method_8404(frog.method_24515()), class_3730.field_16468, null, null);
            frog.method_5977(this.method_5987());
            if (this.method_16914()) {
                frog.method_5665(this.method_5797());
                frog.method_5880(this.method_5807());
            }
            frog.method_5971();
            this.method_5783(WBSoundEvents.TADPOLE_GROW_UP, 0.15f, 1.0f);
            server.method_30771((class_1297)frog);
            this.method_31472();
        }
    }

    private int getTicksUntilGrowth() {
        return Math.max(0, MAX_TADPOLE_AGE - this.age);
    }

    protected boolean method_6054() {
        return false;
    }
}

