/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities;

import com.cursedcauldron.wildbackport.WildBackport;
import com.cursedcauldron.wildbackport.client.animation.api.AnimationState;
import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.access.api.Poses;
import com.cursedcauldron.wildbackport.common.entities.brain.WardenBrain;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.SonicBoom;
import com.cursedcauldron.wildbackport.common.entities.warden.Angriness;
import com.cursedcauldron.wildbackport.common.entities.warden.MobPositionSource;
import com.cursedcauldron.wildbackport.common.entities.warden.VibrationHandler;
import com.cursedcauldron.wildbackport.common.entities.warden.WardenAngerManager;
import com.cursedcauldron.wildbackport.common.registry.WBMobEffects;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.tag.WBGameEventTags;
import com.cursedcauldron.wildbackport.common.utils.MobUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import org.slf4j.Logger;

public class Warden
extends class_1588
implements VibrationHandler.VibrationConfig {
    public static final byte PLAY_ATTACK_SOUND = 4;
    public static final byte EARS_TWITCH = 61;
    public static final byte SONIC_BOOM = 62;
    private static final class_2940<Integer> ANGER = class_2945.method_12791(Warden.class, (class_2941)class_2943.field_13327);
    private int tendrilPitchEnd;
    private int tendrilPitchStart;
    private int heartPitchEnd;
    private int heartPitchStart;
    public AnimationState roaringAnimationState = new AnimationState();
    public AnimationState sniffingAnimationState = new AnimationState();
    public AnimationState emergingAnimationState = new AnimationState();
    public AnimationState diggingAnimationState = new AnimationState();
    public AnimationState attackingAnimationState = new AnimationState();
    public AnimationState sonicBoomAnimationState = new AnimationState();
    private final class_5715 gameEventHandler;
    private final VibrationHandler listener;
    private WardenAngerManager angerManager = new WardenAngerManager(this::isValidTarget, Collections.emptyList());

    public Warden(class_1299<? extends class_1588> type, class_1937 level) {
        super(type, level);
        this.listener = new VibrationHandler(new MobPositionSource((class_1297)this, this.method_5751()), 16, this);
        this.gameEventHandler = new class_5715((class_5714)this.listener);
        this.field_6194 = 5;
        this.method_5942().method_6354(true);
        this.method_5941(class_7.field_25418, 0.0f);
        this.method_5941(class_7.field_17, 8.0f);
        this.method_5941(class_7.field_33534, 8.0f);
        this.method_5941(class_7.field_14, 8.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.method_5941(class_7.field_9, 0.0f);
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this, this.hasPose(Poses.EMERGING.get()) ? 1 : 0);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (packet.method_11166() == 1) {
            this.method_18380(Poses.EMERGING.get());
        }
    }

    public boolean method_5957(class_4538 reader) {
        return super.method_5957(reader) && reader.method_8587((class_1297)this, this.method_5864().method_18386().method_30757(this.method_19538()));
    }

    public float method_6144(class_2338 pos, class_4538 reader) {
        return 0.0f;
    }

    public boolean method_5679(class_1282 source) {
        return this.isDiggingOrEmerging() && !source.method_5538() || super.method_5679(source);
    }

    private boolean isDiggingOrEmerging() {
        return this.hasPose(Poses.DIGGING.get()) || this.hasPose(Poses.EMERGING.get());
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    protected float method_5867() {
        return this.field_5994 + 0.55f;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23722, 1.5).method_26868(class_5134.field_23721, 30.0);
    }

    public boolean method_33189() {
        return true;
    }

    protected float method_6107() {
        return 4.0f;
    }

    @Nullable
    protected class_3414 method_5994() {
        return !this.hasPose(Poses.ROARING.get()) && !this.isDiggingOrEmerging() ? this.getAngriness().getSound() : null;
    }

    protected class_3414 method_6011(class_1282 source) {
        return WBSoundEvents.WARDEN_HURT;
    }

    protected class_3414 method_6002() {
        return WBSoundEvents.WARDEN_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(WBSoundEvents.WARDEN_STEP, 10.0f, 1.0f);
    }

    public boolean method_6121(class_1297 entity) {
        this.field_6002.method_8421((class_1297)this, (byte)4);
        this.method_5783(WBSoundEvents.WARDEN_ATTACK_IMPACT, 10.0f, this.method_6017());
        SonicBoom.setCooldown((class_1309)this, 40L);
        return super.method_6121(entity);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANGER, (Object)0);
    }

    public int getAnger() {
        return (Integer)this.field_6011.method_12789(ANGER);
    }

    private void updateAnger() {
        this.field_6011.method_12778(ANGER, (Object)this.getPrimeSuspectAnger());
    }

    public void method_5773() {
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            this.listener.tick((class_1937)server);
            if (this.method_5947() || this.method_17326()) {
                WardenBrain.resetDigCooldown((class_1309)this);
            }
        }
        super.method_5773();
        if (this.field_6002.method_8608()) {
            if (this.field_6012 % this.getHeartRate() == 0) {
                this.heartPitchEnd = 10;
                if (!this.method_5701()) {
                    this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), WBSoundEvents.WARDEN_HEARTBEAT, this.method_5634(), 5.0f, this.method_6017(), false);
                }
            }
            this.tendrilPitchStart = this.tendrilPitchEnd;
            if (this.tendrilPitchEnd > 0) {
                --this.tendrilPitchEnd;
            }
            this.heartPitchStart = this.heartPitchEnd;
            if (this.heartPitchEnd > 0) {
                --this.heartPitchEnd;
            }
            if (this.hasPose(Poses.EMERGING.get())) {
                this.addDigParticles(this.emergingAnimationState);
            }
            if (this.hasPose(Poses.DIGGING.get())) {
                this.addDigParticles(this.diggingAnimationState);
            }
        }
    }

    protected void method_5958() {
        class_3218 level = (class_3218)this.field_6002;
        level.method_16107().method_15396("wardenBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        this.field_6002.method_16107().method_15407();
        super.method_5958();
        if ((this.field_6012 + this.method_5628()) % 120 == 0) {
            Warden.addDarknessToClosePlayers(level, this.method_19538(), (class_1297)this, 20);
        }
        if (this.field_6012 % 20 == 0) {
            this.angerManager.tick(level, this::isValidTarget);
            this.updateAnger();
        }
        WardenBrain.updateActivities(this);
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.roaringAnimationState.stop();
            this.attackingAnimationState.start(this.field_6012);
        } else if (status == 61) {
            this.tendrilPitchEnd = 10;
        } else if (status == 62) {
            this.sonicBoomAnimationState.start(this.field_6012);
        } else {
            super.method_5711(status);
        }
    }

    private int getHeartRate() {
        return 40 - class_3532.method_15375((float)(class_3532.method_15363((float)((float)this.getAnger() / (float)Angriness.ANGRY.getThreshold()), (float)0.0f, (float)1.0f) * 30.0f));
    }

    public float getTendrilPitch(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.tendrilPitchStart, (float)this.tendrilPitchEnd) / 10.0f;
    }

    public float getHeartPitch(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.heartPitchStart, (float)this.heartPitchEnd) / 10.0f;
    }

    private void addDigParticles(AnimationState animationState) {
        if ((float)animationState.runningTime() < 4500.0f) {
            Random random = this.method_6051();
            class_2680 state = this.method_25936();
            if (state.method_26217() != class_2464.field_11455) {
                for (int i = 0; i < 30; ++i) {
                    double x = this.method_23317() + (double)class_3532.method_32750((Random)random, (float)-0.7f, (float)0.7f);
                    double y = this.method_23318();
                    double z = this.method_23321() + (double)class_3532.method_32750((Random)random, (float)-0.7f, (float)0.7f);
                    this.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, state), x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void method_5674(class_2940<?> data) {
        if (field_18064.equals(data)) {
            if (this.hasPose(Poses.EMERGING.get())) {
                this.emergingAnimationState.start(this.field_6012);
            } else if (this.hasPose(Poses.DIGGING.get())) {
                this.diggingAnimationState.start(this.field_6012);
            } else if (this.hasPose(Poses.ROARING.get())) {
                this.roaringAnimationState.start(this.field_6012);
            } else if (this.hasPose(Poses.SNIFFING.get())) {
                this.sniffingAnimationState.start(this.field_6012);
            }
        }
        super.method_5674(data);
    }

    public boolean hasPose(class_4050 pose) {
        return this.method_18376() == pose;
    }

    public boolean method_5659() {
        return this.isDiggingOrEmerging();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return WardenBrain.makeBrain(this, dynamic);
    }

    public class_4095<Warden> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    @Override
    public class_6862<class_5712> getListenableEvents() {
        return WBGameEventTags.WARDEN_CAN_LISTEN;
    }

    @Override
    public boolean canTriggerAvoidVibration() {
        return true;
    }

    public boolean isValidTarget(@Nullable class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            return this.field_6002 == entity.field_6002 && class_1301.field_6156.test(entity) && !this.method_5722(entity) && living.method_5864() != class_1299.field_6131 && living.method_5864() != WBEntityTypes.WARDEN.get() && !living.method_5655() && !living.method_29504() && this.field_6002.method_8621().method_11966(living.method_5829());
        }
        return false;
    }

    public static void addDarknessToClosePlayers(class_3218 world, class_243 pos, @Nullable class_1297 entity, int range) {
        class_1293 instance = new class_1293(WBMobEffects.DARKNESS.get(), 260, 0, false, false);
        MobUtils.addEffectToPlayersWithinDistance(world, entity, pos, range, instance, 200);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        WardenAngerManager.codec(this::isValidTarget).encodeStart((DynamicOps)class_2509.field_11560, (Object)this.angerManager).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(manager -> tag.method_10566("anger", manager));
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("anger")) {
            WardenAngerManager.codec(this::isValidTarget).parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("anger"))).resultOrPartial(arg_0 -> ((Logger)WildBackport.LOGGER).error(arg_0)).ifPresent(manager -> {
                this.angerManager = manager;
            });
            this.updateAnger();
        }
    }

    private void playListeningSound() {
        if (!this.hasPose(Poses.ROARING.get())) {
            this.method_5783(this.getAngriness().getListeningSound(), 10.0f, this.method_6017());
        }
    }

    public Angriness getAngriness() {
        return Angriness.getForAnger(this.getPrimeSuspectAnger());
    }

    public int getPrimeSuspectAnger() {
        return this.angerManager.getAngerFor((class_1297)this.method_5968());
    }

    public void removeSuspect(class_1297 entity) {
        this.angerManager.removeSuspect(entity);
    }

    public void increaseAngerAt(class_1297 entity) {
        this.increaseAngerAt(entity, 35, true);
    }

    public void increaseAngerAt(class_1297 entity, int amount, boolean listening) {
        if (!this.method_5987() && this.isValidTarget(entity)) {
            WardenBrain.resetDigCooldown((class_1309)this);
            boolean targetNotPlayer = !(this.method_18868().method_18904(class_4140.field_22355).orElse(null) instanceof class_1657);
            int anger = this.angerManager.increaseAngerAt(entity, amount);
            if (entity instanceof class_1657 && targetNotPlayer && Angriness.getForAnger(anger).isAngry()) {
                this.method_18868().method_18875(class_4140.field_22355);
            }
            if (listening) {
                this.playListeningSound();
            }
        }
    }

    public Optional<class_1309> getPrimeSuspect() {
        return this.getAngriness().isAngry() ? this.angerManager.getPrimeSuspect() : Optional.empty();
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_18868().method_18904(class_4140.field_22355).orElse(null);
    }

    public boolean method_5974(double sqrDist) {
        return false;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 instance, class_3730 spawn, @Nullable class_1315 data, @Nullable class_2487 tag) {
        this.method_18868().method_24525(WBMemoryModules.DIG_COOLDOWN.get(), (Object)class_3902.field_17274, 1200L);
        if (spawn == class_3730.field_16461) {
            this.method_18380(Poses.EMERGING.get());
            this.method_18868().method_24525(WBMemoryModules.IS_EMERGING.get(), (Object)class_3902.field_17274, (long)WardenBrain.EMERGE_DURATION);
            this.method_5783(WBSoundEvents.WARDEN_AGITATED, 5.0f, 1.0f);
        }
        return super.method_5943(level, instance, spawn, data, tag);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean hurt = super.method_5643(source, amount);
        if (!(this.field_6002.field_9236 || this.method_5987() || this.isDiggingOrEmerging())) {
            class_1297 entity = source.method_5529();
            this.increaseAngerAt(entity, Angriness.ANGRY.getThreshold() + 20, false);
            if (this.field_18321.method_18904(class_4140.field_22355).isEmpty() && entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                if (!(source instanceof class_1284) || this.method_24516((class_1297)living, 5.0)) {
                    this.updateAttackTarget(living);
                }
            }
        }
        return hurt;
    }

    public void updateAttackTarget(class_1309 entity) {
        this.method_18868().method_18875(WBMemoryModules.ROAR_TARGET.get());
        this.method_18868().method_18878(class_4140.field_22355, (Object)entity);
        this.method_18868().method_18875(class_4140.field_19293);
        SonicBoom.setCooldown((class_1309)this, 200L);
    }

    public class_4048 method_18377(class_4050 pose) {
        class_4048 dimensions = super.method_18377(pose);
        return this.isDiggingOrEmerging() ? class_4048.method_18385((float)dimensions.field_18067, (float)1.0f) : dimensions;
    }

    public boolean method_5810() {
        return !this.isDiggingOrEmerging() && super.method_5810();
    }

    protected void method_6087(class_1297 entity) {
        if (!this.method_5987() && !this.method_18868().method_18896(WBMemoryModules.TOUCH_COOLDOWN.get())) {
            this.method_18868().method_24525(WBMemoryModules.TOUCH_COOLDOWN.get(), (Object)class_3902.field_17274, 20L);
            this.increaseAngerAt(entity);
            WardenBrain.lookAtDisturbance(this, entity.method_24515());
        }
        super.method_6087(entity);
    }

    @Override
    public boolean shouldListen(class_3218 level, class_5714 listener, class_2338 pos, class_5712 event, @Nullable class_1297 entity) {
        if (!(this.method_5987() || this.method_29504() || this.method_18868().method_18896(WBMemoryModules.VIBRATION_COOLDOWN.get()) || this.isDiggingOrEmerging() || !level.method_8621().method_11952(pos) || this.method_31481() || this.field_6002 != level)) {
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                return this.isValidTarget((class_1297)living);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSignalReceive(class_3218 level, class_5714 listener, class_2338 pos, class_5712 event, @Nullable class_1297 entity, @Nullable class_1297 source, float distance) {
        if (!this.method_29504()) {
            this.field_18321.method_24525(WBMemoryModules.VIBRATION_COOLDOWN.get(), (Object)class_3902.field_17274, 40L);
            level.method_8421((class_1297)this, (byte)61);
            this.method_5783(WBSoundEvents.WARDEN_TENDRIL_CLICKS, 5.0f, this.method_6017());
            class_2338 position = pos;
            if (source != null) {
                if (this.method_24516(source, 30.0)) {
                    if (this.method_18868().method_18896(WBMemoryModules.RECENT_PROJECTILE.get())) {
                        if (this.isValidTarget(source)) {
                            position = source.method_24515();
                        }
                        this.increaseAngerAt(source);
                    } else {
                        this.increaseAngerAt(source, 10, true);
                    }
                }
                this.method_18868().method_24525(WBMemoryModules.RECENT_PROJECTILE.get(), (Object)class_3902.field_17274, 100L);
            } else {
                this.increaseAngerAt(entity);
            }
            if (!this.getAngriness().isAngry()) {
                Optional<class_1309> primeSuspect = this.angerManager.getPrimeSuspect();
                if (source != null || primeSuspect.isEmpty() || primeSuspect.get() == entity) {
                    WardenBrain.lookAtDisturbance(this, position);
                }
            }
        }
    }

    @Nullable
    public class_5715 method_32877() {
        return this.gameEventHandler;
    }

    public boolean closerThan(class_1297 entity, double xzRange, double yRange) {
        double x = entity.method_23317() - this.method_23317();
        double y = entity.method_23318() - this.method_23318();
        double z = entity.method_23321() - this.method_23321();
        return class_3532.method_41189((double)x, (double)z) < class_3532.method_33723((double)xzRange) && class_3532.method_33723((double)y) < class_3532.method_33723((double)yRange);
    }
}

