/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain;

import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Digging;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Dismount;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Emerging;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.FindRoarTarget;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.ForgetAttackTarget;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.GoToTargetLocation;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Roar;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.SetWardenLookTarget;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.Sniffing;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.SonicBoom;
import com.cursedcauldron.wildbackport.common.entities.brain.warden.TryToSniff;
import com.cursedcauldron.wildbackport.common.registry.entity.WBActivities;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.cursedcauldron.wildbackport.common.registry.entity.WBSensorTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_5134;

public class WardenBrain {
    private static final int DIGGING_DURATION = class_3532.method_15386((float)100.0f);
    public static final int EMERGE_DURATION = class_3532.method_15386((float)133.59999f);
    public static final int ROAR_DURATION = class_3532.method_15386((float)84.0f);
    private static final int SNIFFING_DURATION = class_3532.method_15386((float)83.2f);
    private static final List<class_4149<? extends class_4148<? super Warden>>> SENSOR_TYPES = List.of(class_4149.field_18467, WBSensorTypes.WARDEN_ENTITY_SENSOR.get());
    private static final List<class_4140<?>> MEMORY_TYPES = List.of(class_4140.field_18441, class_4140.field_18442, class_4140.field_18444, class_4140.field_22354, class_4140.field_25360, class_4140.field_18446, class_4140.field_18445, class_4140.field_19293, class_4140.field_18449, class_4140.field_22355, class_4140.field_22475, class_4140.field_30243, WBMemoryModules.ROAR_TARGET.get(), WBMemoryModules.DISTURBANCE_LOCATION.get(), WBMemoryModules.RECENT_PROJECTILE.get(), WBMemoryModules.IS_SNIFFING.get(), WBMemoryModules.IS_EMERGING.get(), WBMemoryModules.ROAR_SOUND_DELAY.get(), WBMemoryModules.DIG_COOLDOWN.get(), WBMemoryModules.ROAR_SOUND_COOLDOWN.get(), WBMemoryModules.SNIFF_COOLDOWN.get(), WBMemoryModules.TOUCH_COOLDOWN.get(), WBMemoryModules.VIBRATION_COOLDOWN.get(), WBMemoryModules.SONIC_BOOM_COOLDOWN.get(), WBMemoryModules.SONIC_BOOM_SOUND_COOLDOWN.get(), WBMemoryModules.SONIC_BOOM_SOUND_DELAY.get());
    private static final class_4097<Warden> DIG_COOLDOWN_SETTER = new class_4097<Warden>((Map)ImmutableMap.of(WBMemoryModules.DIG_COOLDOWN.get(), (Object)class_4141.field_18458)){

        protected void start(class_3218 level, Warden warden, long time) {
            WardenBrain.resetDigCooldown((class_1309)warden);
        }
    };

    public static void updateActivities(Warden warden) {
        warden.method_18868().method_24531((List)ImmutableList.of((Object)WBActivities.EMERGE.get(), (Object)WBActivities.DIG.get(), (Object)WBActivities.ROAR.get(), (Object)class_4168.field_22396, (Object)WBActivities.INVESTIGATE.get(), (Object)WBActivities.SNIFF.get(), (Object)class_4168.field_18595));
    }

    public static class_4095<?> makeBrain(Warden warden, Dynamic<?> dynamic) {
        class_4095.class_5303 provider = class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
        class_4095 brain = provider.method_28335(dynamic);
        WardenBrain.initCoreActivity((class_4095<Warden>)brain);
        WardenBrain.initEmergeActivity((class_4095<Warden>)brain);
        WardenBrain.initDiggingActivity((class_4095<Warden>)brain);
        WardenBrain.initIdleActivity((class_4095<Warden>)brain);
        WardenBrain.initRoarActivity((class_4095<Warden>)brain);
        WardenBrain.initFightActivity(warden, (class_4095<Warden>)brain);
        WardenBrain.initInvestigateActivity((class_4095<Warden>)brain);
        WardenBrain.initSniffingActivity((class_4095<Warden>)brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(class_4095<Warden> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)((Object)new SetWardenLookTarget()), (Object)new class_4110(45, 90), (Object)new class_4112()));
    }

    private static void initEmergeActivity(class_4095<Warden> brain) {
        brain.method_24527(WBActivities.EMERGE.get(), 5, ImmutableList.of(new Emerging(EMERGE_DURATION)), WBMemoryModules.IS_EMERGING.get());
    }

    private static void initDiggingActivity(class_4095<Warden> brain) {
        brain.method_24529(WBActivities.DIG.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Dismount())), (Object)Pair.of((Object)1, new Digging(DIGGING_DURATION))), (Set)ImmutableSet.of((Object)Pair.of(WBMemoryModules.ROAR_TARGET.get(), (Object)class_4141.field_18457), (Object)Pair.of(WBMemoryModules.DIG_COOLDOWN.get(), (Object)class_4141.field_18457)));
    }

    private static void initIdleActivity(class_4095<Warden> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of(new FindRoarTarget<Warden>(Warden::getPrimeSuspect), (Object)((Object)new TryToSniff()), (Object)new class_4118((Map)ImmutableMap.of(WBMemoryModules.IS_SNIFFING.get(), (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)new class_4818(0.5f), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)))));
    }

    private static void initInvestigateActivity(class_4095<Warden> brain) {
        brain.method_24527(WBActivities.INVESTIGATE.get(), 5, ImmutableList.of(new FindRoarTarget<Warden>(Warden::getPrimeSuspect), new GoToTargetLocation(WBMemoryModules.DISTURBANCE_LOCATION.get(), 2, 0.7f)), WBMemoryModules.DISTURBANCE_LOCATION.get());
    }

    private static void initSniffingActivity(class_4095<Warden> brain) {
        brain.method_24527(WBActivities.SNIFF.get(), 5, ImmutableList.of(new FindRoarTarget<Warden>(Warden::getPrimeSuspect), new Sniffing(SNIFFING_DURATION)), WBMemoryModules.IS_SNIFFING.get());
    }

    private static void initRoarActivity(class_4095<Warden> brain) {
        brain.method_24527(WBActivities.ROAR.get(), 10, ImmutableList.of((Object)((Object)new Roar())), WBMemoryModules.ROAR_TARGET.get());
    }

    private static void initFightActivity(Warden warden, class_4095<Warden> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of(DIG_COOLDOWN_SETTER, new ForgetAttackTarget<Warden>(entity -> !warden.getAngriness().isAngry() || !warden.isValidTarget((class_1297)entity), WardenBrain::removeDeadSuspect, false), (Object)new class_4119(entity -> WardenBrain.isTargeting(warden, entity), (float)warden.method_26825(class_5134.field_23717)), (Object)new class_4822(1.2f), (Object)((Object)new SonicBoom()), (Object)new class_4816(18)), class_4140.field_22355);
    }

    private static boolean isTargeting(Warden warden, class_1309 entity) {
        return warden.method_18868().method_18904(class_4140.field_22355).filter(target -> target == entity).isPresent();
    }

    private static void removeDeadSuspect(Warden warden, class_1309 suspect) {
        if (!warden.isValidTarget((class_1297)suspect)) {
            warden.removeSuspect((class_1297)suspect);
        }
        WardenBrain.resetDigCooldown((class_1309)warden);
    }

    public static void resetDigCooldown(class_1309 warden) {
        if (warden.method_18868().method_18896(WBMemoryModules.DIG_COOLDOWN.get())) {
            warden.method_18868().method_24525(WBMemoryModules.DIG_COOLDOWN.get(), (Object)class_3902.field_17274, 1200L);
        }
    }

    public static void lookAtDisturbance(Warden warden, class_2338 pos) {
        if (warden.field_6002.method_8621().method_11952(pos) && warden.getPrimeSuspect().isEmpty() && warden.method_18868().method_18904(class_4140.field_22355).isEmpty()) {
            WardenBrain.resetDigCooldown((class_1309)warden);
            warden.method_18868().method_24525(WBMemoryModules.SNIFF_COOLDOWN.get(), (Object)class_3902.field_17274, 100L);
            warden.method_18868().method_24525(class_4140.field_18446, (Object)new class_4099(pos), 100L);
            warden.method_18868().method_24525(WBMemoryModules.DISTURBANCE_LOCATION.get(), (Object)pos, 100L);
            warden.method_18868().method_18875(class_4140.field_18445);
        }
    }
}

