/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.frog;

import com.cursedcauldron.wildbackport.common.entities.brain.frog.FrogJumpToRandomPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_6019;
import net.minecraft.class_6862;

public class BiasedLongJumpTask<E extends class_1308>
extends FrogJumpToRandomPos<E> {
    private final class_6862<class_2248> preferredBlocks;
    private final float chance;
    private final List<FrogJumpToRandomPos.Target> targetCandidates = new ArrayList<FrogJumpToRandomPos.Target>();
    private boolean priorityOnPreferred;

    public BiasedLongJumpTask(class_6019 cooldown, int yRange, int xzRange, float range, Function<E, class_3414> landingSound, class_6862<class_2248> preferredBlocks, float chance, Predicate<class_2680> landingBlocks) {
        super(cooldown, yRange, xzRange, range, landingSound, landingBlocks);
        this.preferredBlocks = preferredBlocks;
        this.chance = chance;
    }

    @Override
    protected void start(class_3218 level, E entity, long time) {
        super.start(level, entity, time);
        this.targetCandidates.clear();
        this.priorityOnPreferred = entity.method_6051().nextFloat() < this.chance;
    }

    @Override
    protected Optional<FrogJumpToRandomPos.Target> jumpTarget(class_3218 level) {
        if (!this.priorityOnPreferred) {
            return super.jumpTarget(level);
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        while (!this.targets.isEmpty()) {
            Optional<FrogJumpToRandomPos.Target> jumpTarget = super.jumpTarget(level);
            if (!jumpTarget.isPresent()) continue;
            FrogJumpToRandomPos.Target target = jumpTarget.get();
            if (level.method_8320((class_2338)mutable.method_25505((class_2382)target.getPos(), class_2350.field_11033)).method_26164(this.preferredBlocks)) {
                return jumpTarget;
            }
            this.targetCandidates.add(target);
        }
        return !this.targetCandidates.isEmpty() ? Optional.of(this.targetCandidates.remove(0)) : Optional.empty();
    }

    @Override
    protected boolean canLandOn(class_3218 level, E entity, class_2338 pos) {
        return super.canLandOn(level, entity, pos) && this.cantLandInFluid(level, pos);
    }

    private boolean cantLandInFluid(class_3218 level, class_2338 pos) {
        return level.method_8316(pos).method_15769() && level.method_8316(pos.method_10074()).method_15769();
    }
}

