/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.frog;

import com.cursedcauldron.wildbackport.common.entities.Frog;
import com.cursedcauldron.wildbackport.common.entities.access.api.Poses;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1589;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4215;

public class FrogEat
extends class_4097<Frog> {
    private int eatTick;
    private int moveToTargetTick;
    private final class_3414 tongueSound;
    private final class_3414 eatSound;
    private Phase phase = Phase.DONE;

    public FrogEat(class_3414 tongueSound, class_3414 eatSound) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457, (Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456), 100);
        this.tongueSound = tongueSound;
        this.eatSound = eatSound;
    }

    protected boolean checkExtraStartConditions(class_3218 level, Frog frog) {
        class_1309 target = (class_1309)frog.method_18868().method_18904(class_4140.field_22355).get();
        boolean flag = this.canMoveToTarget(frog, target);
        if (!flag) {
            frog.method_18868().method_18875(class_4140.field_22355);
            this.cantReachTarget(frog, target);
        }
        return flag && frog.method_18376() != Poses.CROAKING.get() && Frog.isValidFrogFood(target);
    }

    protected boolean canStillUse(class_3218 level, Frog frog, long time) {
        return frog.method_18868().method_18896(class_4140.field_22355) && this.phase != Phase.DONE;
    }

    protected void start(class_3218 level, Frog frog, long time) {
        class_1309 entity = (class_1309)frog.method_18868().method_18904(class_4140.field_22355).get();
        class_4215.method_19554((class_1309)frog, (class_1309)entity);
        frog.setFrogTarget((class_1297)entity);
        frog.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(entity.method_19538(), 2.0f, 0));
        this.moveToTargetTick = 10;
        this.phase = Phase.MOVE_TO_TARGET;
    }

    protected void stop(class_3218 level, Frog frog, long time) {
        frog.method_18868().method_18875(class_4140.field_22355);
        frog.clearFrogTarget();
        frog.method_18380(class_4050.field_18076);
    }

    private void eat(class_3218 level, Frog frog) {
        class_1297 entity;
        level.method_8449(null, (class_1297)frog, this.eatSound, class_3419.field_15254, 2.0f, 1.0f);
        Optional<class_1297> target = frog.getFrogTarget();
        if (target.isPresent() && (entity = target.get()).method_5805()) {
            frog.method_6121(entity);
            if (!entity.method_5805()) {
                entity.method_5775(FrogEat.dropStack(frog, entity));
                entity.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    private static class_1799 dropStack(Frog frog, class_1297 entity) {
        if (entity instanceof class_1589) {
            return new class_1799((class_1935)(switch (frog.getVariant()) {
                default -> throw new IncompatibleClassChangeError();
                case Frog.Variant.TEMPERATE -> WBBlocks.OCHRE_FROGLIGHT.get().method_8389();
                case Frog.Variant.WARM -> WBBlocks.PEARLESCENT_FROGLIGHT.get().method_8389();
                case Frog.Variant.COLD -> WBBlocks.VERDANT_FROGLIGHT.get().method_8389();
            }));
        }
        return new class_1799((class_1935)class_1802.field_8777);
    }

    protected void tick(class_3218 level, Frog frog, long time) {
        class_1309 target = (class_1309)frog.method_18868().method_18904(class_4140.field_22355).get();
        frog.setFrogTarget((class_1297)target);
        switch (this.phase) {
            case MOVE_TO_TARGET: {
                if (target.method_5739((class_1297)frog) < 1.75f) {
                    level.method_8449(null, (class_1297)frog, this.tongueSound, class_3419.field_15254, 2.0f, 1.0f);
                    frog.method_18380(Poses.USING_TONGUE.get());
                    target.method_18799(target.method_19538().method_1035(frog.method_19538()).method_1029().method_1021(0.75));
                    this.eatTick = 0;
                    this.phase = Phase.CATCH_ANIMATION;
                    break;
                }
                if (this.moveToTargetTick <= 0) {
                    frog.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(target.method_19538(), 2.0f, 0));
                    this.moveToTargetTick = 10;
                    break;
                }
                --this.moveToTargetTick;
                break;
            }
            case CATCH_ANIMATION: {
                if (this.eatTick++ < 6) break;
                this.phase = Phase.EAT_ANIMATION;
                this.eat(level, frog);
                break;
            }
            case EAT_ANIMATION: {
                if (this.eatTick >= 10) {
                    this.phase = Phase.DONE;
                    break;
                }
                ++this.eatTick;
            }
        }
    }

    private boolean canMoveToTarget(Frog frog, class_1309 entity) {
        class_11 path = frog.method_5942().method_6349((class_1297)entity, 0);
        return path != null && path.method_21656() < 1.75f;
    }

    private void cantReachTarget(Frog frog, class_1309 entity) {
        boolean notTargeting;
        List targets = frog.method_18868().method_18904(WBMemoryModules.UNREACHABLE_TONGUE_TARGETS.get()).orElseGet(ArrayList::new);
        boolean bl = notTargeting = !targets.contains(entity.method_5667());
        if (targets.size() == 5 && notTargeting) {
            targets.remove(0);
        }
        if (notTargeting) {
            targets.add(entity.method_5667());
        }
        frog.method_18868().method_24525(WBMemoryModules.UNREACHABLE_TONGUE_TARGETS.get(), (Object)targets, 100L);
    }

    static enum Phase {
        MOVE_TO_TARGET,
        CATCH_ANIMATION,
        EAT_ANIMATION,
        DONE;

    }
}

