/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.frog;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class FrogJumpToRandomPos<E extends class_1308>
extends class_4097<E> {
    private static final List<Integer> ANGLES = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    private final class_6019 cooldown;
    protected final int yRange;
    protected final int xzRange;
    protected final float maxRange;
    protected List<Target> targets = Lists.newArrayList();
    protected Optional<class_243> lastPos = Optional.empty();
    @Nullable
    protected class_243 lastTarget;
    protected int tries;
    protected long targetTime;
    private final Function<E, class_3414> landingSound;
    private final Predicate<class_2680> landingBlocks;

    public FrogJumpToRandomPos(class_6019 cooldown, int yRange, int xzRange, float range, Function<E, class_3414> landingSound, Predicate<class_2680> landingBlocks) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_30244, (Object)class_4141.field_18457, (Object)class_4140.field_30245, (Object)class_4141.field_18457), 200);
        this.cooldown = cooldown;
        this.yRange = yRange;
        this.xzRange = xzRange;
        this.maxRange = range;
        this.landingSound = landingSound;
        this.landingBlocks = landingBlocks;
    }

    protected boolean checkExtraStartConditions(class_3218 level, class_1308 entity) {
        boolean canUse;
        boolean bl = canUse = entity.method_24828() && !entity.method_5799() && !entity.method_5771() && !level.method_8320(entity.method_24515()).method_27852(class_2246.field_21211);
        if (!canUse) {
            entity.method_18868().method_18878(class_4140.field_30244, (Object)(this.cooldown.method_35008(level.field_9229) / 2));
        }
        return canUse;
    }

    protected boolean canStillUse(class_3218 level, class_1308 entity, long time) {
        boolean canUse;
        boolean bl = canUse = this.lastPos.isPresent() && this.lastPos.get().equals((Object)entity.method_19538()) && this.tries > 0 && !entity.method_5816() && (this.lastTarget != null || !this.targets.isEmpty());
        if (!canUse && entity.method_18868().method_18904(class_4140.field_30245).isEmpty()) {
            entity.method_18868().method_18878(class_4140.field_30244, (Object)(this.cooldown.method_35008(level.field_9229) / 2));
            entity.method_18868().method_18875(class_4140.field_18446);
        }
        return canUse;
    }

    protected void start(class_3218 level, E entity, long time) {
        this.lastTarget = null;
        this.tries = 20;
        this.lastPos = Optional.of(entity.method_19538());
        class_2338 pos = entity.method_24515();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        this.targets = class_2338.method_17962((int)(x - this.xzRange), (int)(y - this.yRange), (int)(z - this.xzRange), (int)(x + this.xzRange), (int)(y + this.yRange), (int)(z + this.xzRange)).filter(position -> !position.equals((Object)pos)).map(position -> new Target(position.method_10062(), class_3532.method_15384((double)pos.method_10262((class_2382)position)))).collect(Collectors.toCollection(Lists::newArrayList));
    }

    protected void tick(class_3218 level, E entity, long time) {
        if (this.lastTarget != null) {
            if (time - this.targetTime >= 40L) {
                entity.method_36456(((class_1308)entity).field_6283);
                entity.method_35054(true);
                double length = this.lastTarget.method_1033();
                double height = length + entity.method_37416();
                entity.method_18799(this.lastTarget.method_1021(height / length));
                entity.method_18868().method_18878(class_4140.field_30245, (Object)true);
                level.method_8449(null, entity, this.landingSound.apply(entity), class_3419.field_15254, 1.0f, 1.0f);
            }
        } else {
            --this.tries;
            this.pickTarget(level, entity, time);
        }
    }

    protected void pickTarget(class_3218 level, E entity, long time) {
        while (!this.targets.isEmpty()) {
            class_243 center;
            class_243 lastTarget;
            Target target;
            class_2338 pos;
            Optional<Target> jumpTarget = this.jumpTarget(level);
            if (jumpTarget.isEmpty() || !this.canLandOn(level, entity, pos = (target = jumpTarget.get()).getPos()) || (lastTarget = this.getRammingVelocity((class_1308)entity, center = class_243.method_24953((class_2382)pos))) == null) continue;
            entity.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(pos));
            class_1408 navigation = entity.method_5942();
            class_11 path = navigation.method_35141(pos, 0, 8);
            if (path != null && path.method_21655()) continue;
            this.lastTarget = lastTarget;
            this.targetTime = time;
            return;
        }
    }

    protected Optional<Target> jumpTarget(class_3218 level) {
        Optional target = class_6011.method_34986((Random)level.field_9229, this.targets);
        target.ifPresent(this.targets::remove);
        return target;
    }

    protected boolean canLandOn(class_3218 level, E entity, class_2338 pos) {
        class_2338 position = entity.method_24515();
        int x = position.method_10263();
        int z = position.method_10260();
        if (x == pos.method_10263() && z == pos.method_10260()) {
            return false;
        }
        if (!entity.method_5942().method_6333(pos) && !this.landingBlocks.test(level.method_8320(pos.method_10074()))) {
            return false;
        }
        return entity.method_5944(class_14.method_23476((class_1922)((class_1308)entity).field_6002, (class_2338.class_2339)pos.method_25503())) == 0.0f;
    }

    @Nullable
    protected class_243 getRammingVelocity(class_1308 entity, class_243 pos) {
        ArrayList angles = Lists.newArrayList(ANGLES);
        Collections.shuffle(angles);
        Iterator iterator = angles.iterator();
        while (iterator.hasNext()) {
            int angle = (Integer)iterator.next();
            class_243 velocity = this.getRammingVelocity(entity, pos, angle);
            if (velocity == null) continue;
            return velocity;
        }
        return null;
    }

    @Nullable
    private class_243 getRammingVelocity(class_1308 entity, class_243 pos, int angle) {
        class_243 position = entity.method_19538();
        class_243 scale = new class_243(pos.field_1352 - position.field_1352, 0.0, pos.field_1350 - position.field_1350).method_1029().method_1021(0.5);
        pos = pos.method_1020(scale);
        class_243 distance = pos.method_1020(position);
        float maxAngle = (float)angle * (float)Math.PI / 180.0f;
        double xzRange = Math.atan2(distance.field_1350, distance.field_1352);
        double yRange = distance.method_1023(0.0, distance.field_1351, 0.0).method_1027();
        double yRadius = Math.sqrt(yRange);
        double i = Math.sin(2.0f * maxAngle);
        double k = Math.pow(Math.cos(maxAngle), 2.0);
        double yMax = Math.sin(maxAngle);
        double xzMax = Math.cos(maxAngle);
        double zOffset = Math.sin(xzRange);
        double xOffset = Math.cos(xzRange);
        double jumpHeight = yRange * 0.08 / (yRadius * i - 2.0 * distance.field_1351 * k);
        if (jumpHeight < 0.0) {
            return null;
        }
        double range = Math.sqrt(jumpHeight);
        if (range > (double)this.maxRange) {
            return null;
        }
        double xzDistance = range * xzMax;
        double yDistance = range * yMax;
        int radius = class_3532.method_15384((double)(yRadius / xzDistance)) * 2;
        double index = 0.0;
        class_243 source = null;
        for (int j = 0; j < radius - 1; ++j) {
            double x = (index += yRadius / (double)radius) * xOffset;
            double y = yMax / xzMax * index - Math.pow(index, 2.0) * 0.08 / (2.0 * jumpHeight * Math.pow(xzMax, 2.0));
            double z = index * zOffset;
            class_243 target = new class_243(position.field_1352 + x, position.field_1351 + y, position.field_1350 + z);
            if (source != null && !this.canReach(entity, source, target)) {
                return null;
            }
            source = target;
        }
        return new class_243(xzDistance * xOffset, yDistance, xzDistance * zOffset).method_1021((double)0.95f);
    }

    private boolean canReach(class_1308 entity, class_243 source, class_243 target) {
        class_4048 dimensions = entity.method_18377(class_4050.field_30095);
        class_243 distance = target.method_1020(source);
        double size = Math.min(dimensions.field_18067, dimensions.field_18068);
        int height = class_3532.method_15384((double)(distance.method_1033() / size));
        class_243 normal = distance.method_1029();
        class_243 vector = source;
        for (int i = 0; i < height; ++i) {
            vector = i == height - 1 ? target : vector.method_1019(normal.method_1021(size * (double)0.9f));
            class_238 box = dimensions.method_30757(vector);
            if (entity.field_6002.method_8587((class_1297)entity, box)) continue;
            return false;
        }
        return true;
    }

    public static class Target
    extends class_6008.class_6009 {
        private final class_2338 pos;

        public Target(class_2338 pos, int weight) {
            super(weight);
            this.pos = pos;
        }

        public class_2338 getPos() {
            return this.pos;
        }
    }
}

