/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class ForgetAttackTarget<E extends class_1308>
extends class_4097<E> {
    private final Predicate<class_1309> alternativeCondition;
    private final BiConsumer<E, class_1309> forgetCallback;
    private final boolean shouldForgetIfTargetUnreachable;

    public ForgetAttackTarget(Predicate<class_1309> alternativeCondition, BiConsumer<E, class_1309> forgetCallback, boolean shouldForgetIfTargetUnreachable) {
        super((Map)ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_19293, (Object)class_4141.field_18458));
        this.alternativeCondition = alternativeCondition;
        this.forgetCallback = forgetCallback;
        this.shouldForgetIfTargetUnreachable = shouldForgetIfTargetUnreachable;
    }

    protected void start(class_3218 level, E entity, long time) {
        class_1309 target = this.getAttackTarget(entity);
        if (!entity.method_18395(target)) {
            this.forgetAttackTarget(entity);
        } else if (this.shouldForgetIfTargetUnreachable && ForgetAttackTarget.cannotReachTarget(entity)) {
            this.forgetAttackTarget(entity);
        } else if (this.isAttackTargetDead(entity)) {
            this.forgetAttackTarget(entity);
        } else if (this.isAttackTargetInAnotherWorld(entity)) {
            this.forgetAttackTarget(entity);
        } else if (this.alternativeCondition.test(this.getAttackTarget(entity))) {
            this.forgetAttackTarget(entity);
        }
    }

    private boolean isAttackTargetInAnotherWorld(E entity) {
        return this.getAttackTarget(entity).field_6002 != ((class_1308)entity).field_6002;
    }

    private class_1309 getAttackTarget(E entity) {
        return (class_1309)entity.method_18868().method_18904(class_4140.field_22355).get();
    }

    private static <E extends class_1309> boolean cannotReachTarget(E entity) {
        Optional time = entity.method_18868().method_18904(class_4140.field_19293);
        return time.isPresent() && entity.field_6002.method_8510() - (Long)time.get() > 200L;
    }

    private boolean isAttackTargetDead(E entity) {
        Optional target = entity.method_18868().method_18904(class_4140.field_22355);
        return target.isPresent() && !((class_1309)target.get()).method_5805();
    }

    protected void forgetAttackTarget(E entity) {
        this.forgetCallback.accept(entity, this.getAttackTarget(entity));
        entity.method_18868().method_18875(class_4140.field_22355);
    }
}

