/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.common.registry.WBPositionSources;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5716;
import net.minecraft.class_5717;

public class MobPositionSource
implements class_5716 {
    public static final Codec<MobPositionSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("source_entity").forGetter(MobPositionSource::getUuid), (App)Codec.FLOAT.fieldOf("y_offset").orElse((Object)Float.valueOf(0.0f)).forGetter(entityPositionSource -> Float.valueOf(entityPositionSource.yOffset))).apply((Applicative)instance, (uUID, float_) -> new MobPositionSource((Either<class_1297, Either<UUID, Integer>>)Either.right((Object)Either.left((Object)uUID)), float_.floatValue())));
    private Either<class_1297, Either<UUID, Integer>> source;
    final float yOffset;

    public MobPositionSource(class_1297 entity, float yOffset) {
        this((Either<class_1297, Either<UUID, Integer>>)Either.left((Object)entity), yOffset);
    }

    public MobPositionSource(Either<class_1297, Either<UUID, Integer>> sourceEntityId, float yOffset) {
        this.source = sourceEntityId;
        this.yOffset = yOffset;
    }

    public Optional<class_2338> method_32956(class_1937 world) {
        if (this.source.left().isEmpty()) {
            this.findEntityInWorld(world);
        }
        return this.source.left().map(entity -> entity.method_24515().method_10080(0.0, (double)this.yOffset, 0.0));
    }

    private void findEntityInWorld(class_1937 world) {
        ((Optional)this.source.map(Optional::of, either -> Optional.ofNullable((class_1297)either.map(uuid -> {
            class_1297 entity;
            if (world instanceof class_3218) {
                class_3218 serverLevel = (class_3218)world;
                entity = serverLevel.method_14190(uuid);
            } else {
                entity = null;
            }
            return entity;
        }, arg_0 -> ((class_1937)world).method_8469(arg_0))))).ifPresent(entity -> {
            this.source = Either.left((Object)entity);
        });
    }

    public class_5717<?> method_32955() {
        return WBPositionSources.MOB.get();
    }

    private UUID getUuid() {
        return (UUID)this.source.map(class_1297::method_5667, either -> (UUID)either.map(Function.identity(), integer -> {
            throw new RuntimeException("Unable to get entityId from uuid");
        }));
    }

    int getEntityId() {
        return (Integer)this.source.map(class_1297::method_5628, either -> (Integer)either.map(uUID -> {
            throw new IllegalStateException("Unable to get entityId from uuid");
        }, Function.identity()));
    }

    public static class Type
    implements class_5717<MobPositionSource> {
        public MobPositionSource read(class_2540 buf) {
            return new MobPositionSource((Either<class_1297, Either<UUID, Integer>>)Either.right((Object)Either.right((Object)buf.method_10816())), buf.readFloat());
        }

        public void write(class_2540 buf, MobPositionSource source) {
            buf.method_10804(source.getEntityId());
            buf.writeFloat(source.yOffset);
        }

        public Codec<MobPositionSource> method_32957() {
            return CODEC;
        }
    }
}

