/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.client.registry.WBCriteriaTriggers;
import com.cursedcauldron.wildbackport.common.utils.PositionUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_5698;
import net.minecraft.class_5699;
import net.minecraft.class_5702;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_5720;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class VibrationHandler
implements class_5714 {
    protected final class_5716 source;
    protected final int range;
    protected final VibrationConfig config;
    @Nullable
    protected Vibration event;
    protected float distance;
    protected int delay;

    public static Codec<VibrationHandler> codec(VibrationConfig config) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_5716.field_28184.fieldOf("source").forGetter(listener -> listener.source), (App)class_5699.field_33441.fieldOf("range").forGetter(listener -> listener.range), (App)Vibration.CODEC.optionalFieldOf("event").forGetter(listener -> Optional.ofNullable(listener.event)), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("event_distance").orElse((Object)Float.valueOf(0.0f)).forGetter(listener -> Float.valueOf(listener.distance)), (App)class_5699.field_33441.fieldOf("event_delay").orElse((Object)0).forGetter(listener -> listener.delay)).apply((Applicative)instance, (source, range, event, distance, delay) -> new VibrationHandler((class_5716)source, (int)range, config, event.orElse(null), distance.floatValue(), (int)delay)));
    }

    public VibrationHandler(class_5716 source, int range, VibrationConfig config, @Nullable Vibration event, float distance, int delay) {
        this.source = source;
        this.range = range;
        this.config = config;
        this.event = event;
        this.distance = distance;
        this.delay = delay;
    }

    public VibrationHandler(class_5716 source, int range, VibrationConfig config) {
        this(source, range, config, null, 0.0f, 0);
    }

    public void tick(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            if (this.event != null) {
                --this.delay;
                if (this.delay <= 0) {
                    this.delay = 0;
                    this.config.onSignalReceive(server, this, new class_2338(this.event.pos), this.event.event, this.event.getEntity(server).orElse(null), this.event.getProjectileOwner(server).orElse(null), this.distance);
                    this.event = null;
                }
            }
        }
    }

    public class_5716 method_32946() {
        return this.source;
    }

    public int method_32948() {
        return this.range;
    }

    public boolean method_32947(class_1937 level, class_5712 event, @Nullable class_1297 entity, class_2338 pos) {
        if (this.event != null) {
            return false;
        }
        Optional optional = this.source.method_32956(level);
        if (!this.config.isValidVibration(event, entity)) {
            return false;
        }
        class_243 source = PositionUtils.toVec(pos);
        class_243 target = PositionUtils.toVec((class_2338)optional.get());
        if (!this.config.shouldListen((class_3218)level, this, new class_2338(source), event, entity)) {
            return false;
        }
        if (VibrationHandler.isOccluded(level, source, target)) {
            return false;
        }
        this.scheduleSignal(level, event, entity, source, target);
        return true;
    }

    private void scheduleSignal(class_1937 level, class_5712 event, @Nullable class_1297 entity, class_243 source, class_243 target) {
        this.distance = (float)source.method_1022(target);
        this.event = new Vibration(event, this.distance, source, entity);
        this.delay = class_3532.method_15375((float)this.distance);
        ((class_3218)level).method_32817(new class_5720(PositionUtils.toBlockPos(source), this.source, this.delay));
        this.config.onSignalSchedule();
    }

    private static boolean isOccluded(class_1937 level, class_243 source, class_243 target) {
        class_243 sourceVec = new class_243((double)class_3532.method_15357((double)source.field_1352) + 0.5, (double)class_3532.method_15357((double)source.field_1351) + 0.5, (double)class_3532.method_15357((double)source.field_1350) + 0.5);
        class_243 targetVec = new class_243((double)class_3532.method_15357((double)target.field_1352) + 0.5, (double)class_3532.method_15357((double)target.field_1351) + 0.5, (double)class_3532.method_15357((double)target.field_1350) + 0.5);
        for (class_2350 direction : class_2350.values()) {
            class_243 offsetVec = PositionUtils.relative(sourceVec, direction, 1.0E-5f);
            if (level.method_32880(new class_5702(offsetVec, targetVec, state -> state.method_26164(class_3481.field_28088))).method_17783() == class_239.class_240.field_1332) continue;
            return false;
        }
        return true;
    }

    public static interface VibrationConfig {
        default public class_6862<class_5712> getListenableEvents() {
            return class_5698.field_28090;
        }

        default public boolean canTriggerAvoidVibration() {
            return false;
        }

        default public boolean isValidVibration(class_5712 event, @Nullable class_1297 entity) {
            if (!event.method_40156(this.getListenableEvents())) {
                return false;
            }
            if (entity != null) {
                if (entity.method_7325()) {
                    return false;
                }
                if (entity.method_21749() && event.method_40156(class_5698.field_28091)) {
                    if (this.canTriggerAvoidVibration() && entity instanceof class_3222) {
                        class_3222 player = (class_3222)entity;
                        WBCriteriaTriggers.AVOID_VIBRATION.method_9027(player);
                    }
                    return false;
                }
                return !entity.method_33189();
            }
            return true;
        }

        public boolean shouldListen(class_3218 var1, class_5714 var2, class_2338 var3, class_5712 var4, @Nullable class_1297 var5);

        public void onSignalReceive(class_3218 var1, class_5714 var2, class_2338 var3, class_5712 var4, @Nullable class_1297 var5, @Nullable class_1297 var6, float var7);

        default public void onSignalSchedule() {
        }
    }

    public record Vibration(class_5712 event, float distance, class_243 pos, @Nullable UUID source, @Nullable UUID projectileOwner, @Nullable class_1297 entity) {
        public static final Codec<Vibration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_28264.method_39673().fieldOf("game_event").forGetter(Vibration::event), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("distance").forGetter(Vibration::distance), (App)PositionUtils.VEC_CODEC.fieldOf("pos").forGetter(Vibration::pos), (App)class_4844.field_25122.optionalFieldOf("source").forGetter(entity -> Optional.ofNullable(entity.source())), (App)class_4844.field_25122.optionalFieldOf("projectile_owner").forGetter(entity -> Optional.ofNullable(entity.projectileOwner()))).apply((Applicative)instance, (event, distance, pos, source, projectileOwner) -> new Vibration((class_5712)event, distance.floatValue(), (class_243)pos, source.orElse(null), projectileOwner.orElse(null))));

        public Vibration(class_5712 event, float distance, class_243 pos, @Nullable UUID source, @Nullable UUID projectileOwner) {
            this(event, distance, pos, source, projectileOwner, null);
        }

        public Vibration(class_5712 event, float distance, class_243 pos, @Nullable class_1297 entity) {
            this(event, distance, pos, entity == null ? null : entity.method_5667(), Vibration.getProjectileOwner(entity), entity);
        }

        @Nullable
        private static UUID getProjectileOwner(@Nullable class_1297 entity) {
            class_1676 projectile;
            if (entity instanceof class_1676 && (projectile = (class_1676)entity).method_24921() != null) {
                return projectile.method_24921().method_5667();
            }
            return null;
        }

        public Optional<class_1297> getEntity(class_3218 level) {
            return Optional.ofNullable(this.entity).or(() -> Optional.ofNullable(this.source).map(arg_0 -> ((class_3218)level).method_14190(arg_0)));
        }

        public Optional<class_1297> getProjectileOwner(class_3218 level) {
            return this.getEntity(level).filter(entity -> entity instanceof class_1676).map(entity -> (class_1676)entity).map(class_1676::method_24921).or(() -> Optional.ofNullable(this.projectileOwner).map(arg_0 -> ((class_3218)level).method_14190(arg_0)));
        }
    }
}

