/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.common.entities.warden.Angriness;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_5699;

public class WardenAngerManager {
    private int updateTimer = class_3532.method_32751((Random)new Random(), (int)0, (int)2);
    int primeAnger;
    private static final Codec<Pair<UUID, Integer>> SUSPECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("uuid").forGetter(Pair::getFirst), (App)class_5699.field_33441.fieldOf("anger").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    private final Predicate<class_1297> suspectPredicate;
    protected final ArrayList<class_1297> suspects;
    private final SuspectComparator suspectComparator;
    protected final Object2IntMap<class_1297> suspectsToAngerLevel;
    protected final Object2IntMap<UUID> suspectUuidsToAngerLevel;

    public static Codec<WardenAngerManager> codec(Predicate<class_1297> validTarget) {
        return RecordCodecBuilder.create(instance -> instance.group((App)SUSPECT_CODEC.listOf().fieldOf("suspects").orElse(Collections.emptyList()).forGetter(WardenAngerManager::getSuspects)).apply((Applicative)instance, suspects -> new WardenAngerManager(validTarget, (List<Pair<UUID, Integer>>)suspects)));
    }

    public WardenAngerManager(Predicate<class_1297> suspectPredicate, List<Pair<UUID, Integer>> suspectUuidsToAngerLevel) {
        this.suspectPredicate = suspectPredicate;
        this.suspects = new ArrayList();
        this.suspectComparator = new SuspectComparator(this);
        this.suspectsToAngerLevel = new Object2IntOpenHashMap();
        this.suspectUuidsToAngerLevel = new Object2IntOpenHashMap(suspectUuidsToAngerLevel.size());
        suspectUuidsToAngerLevel.forEach(suspect -> this.suspectUuidsToAngerLevel.put((Object)((UUID)suspect.getFirst()), (Integer)suspect.getSecond()));
    }

    private List<Pair<UUID, Integer>> getSuspects() {
        return Streams.concat((Stream[])new Stream[]{this.suspects.stream().map(suspect -> Pair.of((Object)suspect.method_5667(), (Object)this.suspectsToAngerLevel.getInt(suspect))), this.suspectUuidsToAngerLevel.object2IntEntrySet().stream().map(entry -> Pair.of((Object)((UUID)entry.getKey()), (Object)entry.getIntValue()))}).collect(Collectors.toList());
    }

    public void tick(class_3218 level, Predicate<class_1297> suspectPredicate) {
        --this.updateTimer;
        if (this.updateTimer <= 0) {
            this.updateSuspectsMap(level);
            this.updateTimer = 2;
        }
        ObjectIterator uuidToAnger = this.suspectUuidsToAngerLevel.object2IntEntrySet().iterator();
        while (uuidToAnger.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)uuidToAnger.next();
            int anger = entry.getIntValue();
            if (anger <= 1) {
                uuidToAnger.remove();
                continue;
            }
            entry.setValue(anger - 1);
        }
        ObjectIterator suspectToAnger = this.suspectsToAngerLevel.object2IntEntrySet().iterator();
        while (suspectToAnger.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)suspectToAnger.next();
            int anger = entry.getIntValue();
            class_1297 entity = (class_1297)entry.getKey();
            class_1297.class_5529 reason = entity.method_35049();
            if (anger > 1 && suspectPredicate.test(entity) && reason == null) {
                entry.setValue(anger - 1);
                continue;
            }
            this.suspects.remove(entity);
            suspectToAnger.remove();
            if (anger <= 1 || reason == null) continue;
            switch (reason) {
                case field_27002: 
                case field_27000: 
                case field_27001: {
                    this.suspectUuidsToAngerLevel.put((Object)entity.method_5667(), anger - 1);
                }
            }
        }
        this.updatePrimeAnger();
    }

    private void updatePrimeAnger() {
        this.primeAnger = 0;
        this.suspects.sort(this.suspectComparator);
        if (this.suspects.size() == 1) {
            this.primeAnger = this.suspectsToAngerLevel.getInt((Object)this.suspects.get(0));
        }
    }

    private void updateSuspectsMap(class_3218 level) {
        ObjectIterator uuidsToAnger = this.suspectUuidsToAngerLevel.object2IntEntrySet().iterator();
        while (uuidsToAnger.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)uuidsToAnger.next();
            int anger = entry.getIntValue();
            class_1297 entity = level.method_14190((UUID)entry.getKey());
            if (entity == null) continue;
            this.suspectsToAngerLevel.put((Object)entity, anger);
            this.suspects.add(entity);
            uuidsToAnger.remove();
        }
    }

    public int increaseAngerAt(class_1297 entity, int amount) {
        boolean isTarget = !this.suspectsToAngerLevel.containsKey((Object)entity);
        int angerLevel = this.suspectsToAngerLevel.computeInt((Object)entity, (suspect, anger) -> Math.min(150, (anger == null ? 0 : anger) + amount));
        if (isTarget) {
            int modifier = this.suspectUuidsToAngerLevel.removeInt((Object)entity.method_5667());
            this.suspectsToAngerLevel.put((Object)entity, angerLevel += modifier);
            this.suspects.add(entity);
        }
        this.updatePrimeAnger();
        return angerLevel;
    }

    public void removeSuspect(class_1297 entity) {
        this.suspectsToAngerLevel.removeInt((Object)entity);
        this.suspects.remove(entity);
        this.updatePrimeAnger();
    }

    @Nullable
    private class_1297 getPrimeSuspectInternal() {
        return this.suspects.stream().filter(this.suspectPredicate).findFirst().orElse(null);
    }

    public int getAngerFor(@Nullable class_1297 entity) {
        return entity == null ? this.primeAnger : this.suspectsToAngerLevel.getInt((Object)entity);
    }

    public Optional<class_1309> getPrimeSuspect() {
        return Optional.ofNullable(this.getPrimeSuspectInternal()).filter(suspect -> suspect instanceof class_1309).map(suspect -> (class_1309)suspect);
    }

    protected record SuspectComparator(WardenAngerManager angerManagement) implements Comparator<class_1297>
    {
        @Override
        public int compare(class_1297 firstSuspect, class_1297 secondSuspect) {
            boolean isAngryWithSecondSuspect;
            if (firstSuspect.equals((Object)secondSuspect)) {
                return 0;
            }
            int angerToFirstSuspect = this.angerManagement.suspectsToAngerLevel.getOrDefault((Object)firstSuspect, 0);
            int angerToSecondSuspect = this.angerManagement.suspectsToAngerLevel.getOrDefault((Object)secondSuspect, 0);
            this.angerManagement.primeAnger = Math.max(this.angerManagement.primeAnger, Math.max(angerToFirstSuspect, angerToSecondSuspect));
            boolean isAngryWithFirstSuspect = Angriness.getForAnger(angerToFirstSuspect).isAngry();
            if (isAngryWithFirstSuspect != (isAngryWithSecondSuspect = Angriness.getForAnger(angerToSecondSuspect).isAngry())) {
                return isAngryWithFirstSuspect ? -1 : 1;
            }
            boolean isFirstSuspectPlayer = firstSuspect instanceof class_1657;
            boolean isSecondSuspectPlayer = secondSuspect instanceof class_1657;
            if (isFirstSuspectPlayer != isSecondSuspectPlayer) {
                return isFirstSuspectPlayer ? -1 : 1;
            }
            return Integer.compare(angerToSecondSuspect, angerToFirstSuspect);
        }
    }
}

