/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.warden;

import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.entities.access.WardenTracker;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5699;

public class WardenSpawnTracker {
    public static final Codec<WardenSpawnTracker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("ticks_since_last_warning").orElse((Object)0).forGetter(tracker -> tracker.ticksSinceLastWarning), (App)class_5699.field_33441.fieldOf("warning_level").orElse((Object)0).forGetter(tracker -> tracker.warningLevel), (App)class_5699.field_33441.fieldOf("cooldown_ticks").orElse((Object)0).forGetter(tracker -> tracker.cooldownTicks)).apply((Applicative)instance, WardenSpawnTracker::new));
    private int ticksSinceLastWarning;
    private int warningLevel;
    private int cooldownTicks;

    public WardenSpawnTracker(int ticksSinceLastWarning, int warningLevel, int cooldownTicks) {
        this.ticksSinceLastWarning = ticksSinceLastWarning;
        this.warningLevel = warningLevel;
        this.cooldownTicks = cooldownTicks;
    }

    public void tick() {
        if (this.ticksSinceLastWarning >= 12000) {
            this.decreaseWarningCount();
            this.ticksSinceLastWarning = 0;
        } else {
            ++this.ticksSinceLastWarning;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
    }

    public void reset() {
        this.ticksSinceLastWarning = 0;
        this.warningLevel = 0;
        this.cooldownTicks = 0;
    }

    private boolean onCooldown() {
        return this.cooldownTicks > 0;
    }

    public static OptionalInt tryWarn(class_3218 level, class_2338 pos, class_3222 player) {
        if (!WardenSpawnTracker.hasNearbyWarden(level, pos)) {
            List<class_3222> players = WardenSpawnTracker.getNearbyPlayers(level, pos);
            if (!players.contains(player)) {
                players.add(player);
            }
            if (players.stream().anyMatch(playerIn -> WardenTracker.of((class_1657)playerIn).getWardenSpawnTracker().onCooldown())) {
                return OptionalInt.empty();
            }
            Optional<WardenSpawnTracker> optional = players.stream().map(WardenTracker::getWardenSpawnTracker).max(Comparator.comparingInt(tracker -> tracker.warningLevel));
            WardenSpawnTracker tracker2 = optional.get();
            tracker2.increaseWarningLevel();
            players.forEach(playerIn -> WardenTracker.of((class_1657)playerIn).getWardenSpawnTracker().copyData(tracker2));
            return OptionalInt.of(tracker2.warningLevel);
        }
        return OptionalInt.empty();
    }

    private static boolean hasNearbyWarden(class_3218 level, class_2338 pos) {
        class_238 box = class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)48.0, (double)48.0, (double)48.0);
        return !level.method_18467(Warden.class, box).isEmpty();
    }

    private static List<class_3222> getNearbyPlayers(class_3218 level, class_2338 pos) {
        class_243 center = class_243.method_24953((class_2382)pos);
        Predicate<class_3222> predicate = player -> player.method_19538().method_24802((class_2374)center, 16.0);
        return level.method_18766(predicate.and(class_1309::method_5805).and(class_1301.field_6155));
    }

    private void increaseWarningLevel() {
        if (!this.onCooldown()) {
            this.ticksSinceLastWarning = 0;
            this.cooldownTicks = 200;
            this.setWarningLevel(this.getWarningLevel() + 1);
        }
    }

    private void decreaseWarningCount() {
        this.setWarningLevel(this.getWarningLevel() - 1);
    }

    public void setWarningLevel(int warningLevel) {
        this.warningLevel = class_3532.method_15340((int)warningLevel, (int)0, (int)4);
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    private void copyData(WardenSpawnTracker tracker) {
        this.ticksSinceLastWarning = tracker.ticksSinceLastWarning;
        this.warningLevel = tracker.warningLevel;
        this.cooldownTicks = tracker.cooldownTicks;
    }

    public void readTag(class_2487 tag) {
        if (tag.method_10573("ticksSinceLastWarning", 99)) {
            this.ticksSinceLastWarning = tag.method_10550("ticksSinceLastWarning");
            this.warningLevel = tag.method_10550("warningCount");
            this.cooldownTicks = tag.method_10550("shriekerCooldownTicks");
        }
    }

    public void writeTag(class_2487 tag) {
        tag.method_10569("ticksSinceLastWarning", this.ticksSinceLastWarning);
        tag.method_10569("warningCount", this.warningLevel);
        tag.method_10569("shriekerCooldownTicks", this.cooldownTicks);
    }
}

