/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.items;

import com.cursedcauldron.wildbackport.common.items.Instrument;
import com.cursedcauldron.wildbackport.common.registry.WBGameEvents;
import com.cursedcauldron.wildbackport.common.registry.WBRegistries;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class GoatHornItem
extends class_1792 {
    private static final String INSTRUMENT_KEY = "instrument";
    private class_6862<Instrument> instruments;

    public GoatHornItem(class_1792.class_1793 properties, class_6862<Instrument> instrumentTag) {
        super(properties);
        this.instruments = instrumentTag;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> components, class_1836 tooltipFlag) {
        super.method_7851(stack, level, components, tooltipFlag);
        Optional instrument = this.getInstrument(stack).flatMap(class_6880::method_40230);
        if (instrument.isPresent()) {
            class_2588 component = new class_2588(class_156.method_646((String)INSTRUMENT_KEY, (class_2960)((class_5321)instrument.get()).method_29177()));
            components.add((class_2561)component.method_27692(class_124.field_1080));
        }
    }

    public static class_1799 getStackForInstrument(class_1792 item, class_6880<Instrument> instrument) {
        class_1799 stack = new class_1799((class_1935)item);
        GoatHornItem.setInstrument(stack, instrument);
        return stack;
    }

    public static void setRandomInstrumentFromTag(class_1799 stack, class_6862<Instrument> tag, Random random) {
        Optional instrument = WBRegistries.INSTRUMENT.registry().method_40266(tag).flatMap(holders -> holders.method_40243(random));
        instrument.ifPresent(holder -> GoatHornItem.setInstrument(stack, (class_6880<Instrument>)holder));
    }

    private static void setInstrument(class_1799 stack, class_6880<Instrument> instrument) {
        stack.method_7948().method_10582(INSTRUMENT_KEY, ((class_5321)instrument.method_40230().orElseThrow(() -> new IllegalStateException("Invalid instrument"))).method_29177().toString());
    }

    public void method_7850(class_1761 tab, class_2371<class_1799> stacks) {
        if (this.method_7877(tab)) {
            for (class_6880 class_68802 : WBRegistries.INSTRUMENT.registry().method_40286(this.instruments)) {
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Optional<class_6880<Instrument>> holder = this.getInstrument(stack);
        if (holder.isPresent()) {
            Instrument instrument = (Instrument)holder.get().comp_349();
            player.method_6019(hand);
            GoatHornItem.playSound(level, player, instrument);
            player.method_7357().method_7906((class_1792)this, instrument.useDuration());
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public int method_7881(class_1799 stack) {
        Optional<class_6880<Instrument>> instrument = this.getInstrument(stack);
        return instrument.map(holder -> ((Instrument)holder.comp_349()).useDuration()).orElse(0);
    }

    private Optional<class_6880<Instrument>> getInstrument(class_1799 stack) {
        class_2960 location;
        class_2487 tag = stack.method_7969();
        if (tag != null && (location = class_2960.method_12829((String)tag.method_10558(INSTRUMENT_KEY))) != null) {
            return WBRegistries.INSTRUMENT.registry().method_40264(class_5321.method_29179(WBRegistries.INSTRUMENT.key(), (class_2960)location));
        }
        Iterator instruments = WBRegistries.INSTRUMENT.registry().method_40286(this.instruments).iterator();
        return instruments.hasNext() ? Optional.of((class_6880)instruments.next()) : Optional.empty();
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_27079;
    }

    private static void playSound(class_1937 level, class_1657 player, Instrument instrument) {
        level.method_8449(player, (class_1297)player, instrument.soundEvent(), class_3419.field_15247, instrument.range() / 16.0f, 1.0f);
        level.method_33596(WBGameEvents.INSTRUMENT_PLAY.get(), (class_1297)player);
    }
}

