/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen;

import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5778;
import org.jetbrains.annotations.Nullable;

public class VeinGrower {
    public static final GrowType[] GROW_TYPES = new GrowType[]{GrowType.SAME_POSITION, GrowType.SAME_PLANE, GrowType.WRAP_AROUND};
    private final GrowChecker growChecker;

    public VeinGrower(class_5778 lichen) {
        this(new VeinGrowChecker(lichen));
    }

    public VeinGrower(GrowChecker growChecker) {
        this.growChecker = growChecker;
    }

    public boolean canGrow(class_2680 state, class_1922 getter, class_2338 pos, class_2350 direction) {
        return DirectionUtils.stream().anyMatch(newDirection -> this.getGrowPos(state, getter, pos, direction, (class_2350)newDirection, this.growChecker::canGrow).isPresent());
    }

    public Optional<GrowPos> grow(class_2680 state, class_1936 level, class_2338 pos, Random random) {
        return DirectionUtils.shuffle(random).stream().filter(direction -> this.growChecker.canGrow(state, (class_2350)direction)).map(direction -> this.grow(state, level, pos, (class_2350)direction, random, false)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public long grow(class_2680 state, class_1936 level, class_2338 pos, boolean postProcess) {
        return DirectionUtils.stream().filter(direction -> this.growChecker.canGrow(state, (class_2350)direction)).map(direction -> this.grow(state, level, pos, (class_2350)direction, postProcess)).reduce(0L, Long::sum);
    }

    public Optional<GrowPos> grow(class_2680 state, class_1936 level, class_2338 pos, class_2350 direction, Random random, boolean postProcess) {
        return DirectionUtils.shuffle(random).stream().map(newDirection -> this.grow(state, level, pos, direction, (class_2350)newDirection, postProcess)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private long grow(class_2680 state, class_1936 level, class_2338 pos, class_2350 direction, boolean postProcess) {
        return DirectionUtils.stream().map(newDirection -> this.grow(state, level, pos, direction, (class_2350)newDirection, postProcess)).filter(Optional::isPresent).count();
    }

    public Optional<GrowPos> grow(class_2680 state, class_1936 world, class_2338 pos, class_2350 oldDirection, class_2350 newDirection, boolean postProcess) {
        return this.getGrowPos(state, (class_1922)world, pos, oldDirection, newDirection, this.growChecker::canGrow).flatMap(growPos -> this.place(world, (GrowPos)growPos, postProcess));
    }

    public Optional<GrowPos> getGrowPos(class_2680 state, class_1922 world, class_2338 pos, class_2350 oldDirection, class_2350 newDirection, GrowPosPredicate predicate) {
        if (newDirection.method_10166() == oldDirection.method_10166()) {
            return Optional.empty();
        }
        if (!(this.growChecker.canGrow(state) || this.growChecker.hasDirection(state, oldDirection) && !this.growChecker.hasDirection(state, newDirection))) {
            return Optional.empty();
        }
        for (GrowType growType : this.growChecker.getGrowTypes()) {
            GrowPos growPos = growType.getGrowPos(pos, newDirection, oldDirection);
            if (!predicate.test(world, pos, growPos)) continue;
            return Optional.of(growPos);
        }
        return Optional.empty();
    }

    public Optional<GrowPos> place(class_1936 world, GrowPos pos, boolean markForPostProcessing) {
        class_2680 state = world.method_8320(pos.pos());
        if (this.growChecker.place(world, pos, state, markForPostProcessing)) {
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public static class VeinGrowChecker
    implements GrowChecker {
        protected class_5778 multifaceBlock;

        public VeinGrowChecker(class_5778 multifaceBlock) {
            this.multifaceBlock = multifaceBlock;
        }

        @Override
        @Nullable
        public class_2680 getStateWithDirection(class_2680 state, class_1922 getter, class_2338 pos, class_2350 face) {
            return this.multifaceBlock.method_33362(state, getter, pos, face);
        }

        protected boolean canGrow(class_1922 getter, class_2338 pos, class_2338 growPos, class_2350 direction, class_2680 state) {
            return state.method_26215() || state.method_27852((class_2248)this.multifaceBlock) || state.method_27852(class_2246.field_10382) && state.method_26227().method_15771();
        }

        @Override
        public boolean canGrow(class_1922 getter, class_2338 pos, GrowPos growPos) {
            class_2680 state = getter.method_8320(growPos.pos());
            return this.canGrow(getter, pos, growPos.pos(), growPos.face(), state) && ((SculkVeinBlock)this.multifaceBlock).canGrowWithDirection(getter, state, growPos.pos(), growPos.face());
        }
    }

    public static interface GrowChecker {
        @Nullable
        public class_2680 getStateWithDirection(class_2680 var1, class_1922 var2, class_2338 var3, class_2350 var4);

        public boolean canGrow(class_1922 var1, class_2338 var2, GrowPos var3);

        default public GrowType[] getGrowTypes() {
            return GROW_TYPES;
        }

        default public boolean hasDirection(class_2680 state, class_2350 direction) {
            return SculkVeinBlock.hasFace(state, direction);
        }

        default public boolean canGrow(class_2680 state) {
            return false;
        }

        default public boolean canGrow(class_2680 state, class_2350 direction) {
            return this.canGrow(state) || this.hasDirection(state, direction);
        }

        default public boolean place(class_1936 world, GrowPos growPos, class_2680 state, boolean postProcess) {
            class_2680 blockState = this.getStateWithDirection(state, (class_1922)world, growPos.pos(), growPos.face());
            if (blockState != null) {
                if (postProcess) {
                    world.method_22350(growPos.pos()).method_12039(growPos.pos());
                }
                return world.method_8652(growPos.pos(), blockState, 2);
            }
            return false;
        }
    }

    public static interface GrowPosPredicate {
        public boolean test(class_1922 var1, class_2338 var2, GrowPos var3);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GrowType {
        SAME_POSITION{

            @Override
            public GrowPos getGrowPos(class_2338 pos, class_2350 newDirection, class_2350 oldDirection) {
                return new GrowPos(pos, newDirection);
            }
        }
        ,
        SAME_PLANE{

            @Override
            public GrowPos getGrowPos(class_2338 pos, class_2350 newDirection, class_2350 oldDirection) {
                return new GrowPos(pos.method_10093(newDirection), oldDirection);
            }
        }
        ,
        WRAP_AROUND{

            @Override
            public GrowPos getGrowPos(class_2338 pos, class_2350 newDirection, class_2350 oldDirection) {
                return new GrowPos(pos.method_10093(newDirection).method_10093(oldDirection), newDirection.method_10153());
            }
        };


        public abstract GrowPos getGrowPos(class_2338 var1, class_2350 var2, class_2350 var3);
    }

    public record GrowPos(class_2338 pos, class_2350 face) {
    }
}

