/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.features;

import com.cursedcauldron.wildbackport.common.worldgen.features.RootedTreeConfig;
import com.cursedcauldron.wildbackport.common.worldgen.placers.UpwardBranchingTrunk;
import com.cursedcauldron.wildbackport.core.mixin.access.TreeFeatureAccessor;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_5141;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class RootedTreeFeature
extends class_3031<RootedTreeConfig> {
    public RootedTreeFeature(Codec<RootedTreeConfig> codec) {
        super(codec);
    }

    private boolean generate(class_5281 level, Random random, class_2338 pos, BiConsumer<class_2338, class_2680> rootPlacerReplacer, BiConsumer<class_2338, class_2680> trunkPlacerReplacer, BiConsumer<class_2338, class_2680> foliagePlacerReplacer, RootedTreeConfig config) {
        int treeHeight = config.field_24136.method_26993(random);
        int foliageHeight = config.field_24135.method_26989(random, treeHeight, (class_4643)config);
        int trunkLength = treeHeight - foliageHeight;
        int foliageRadius = config.field_24135.method_23452(random, trunkLength);
        class_2338 origin = config.rootPlacer.map(rootPlacer -> rootPlacer.trunkOffset(pos, random)).orElse(pos);
        int minHeight = Math.min(pos.method_10264(), origin.method_10264());
        int maxHeight = Math.max(pos.method_10264(), origin.method_10264()) + treeHeight + 1;
        if (minHeight >= level.method_31607() + 1 && maxHeight <= level.method_31600()) {
            OptionalInt clippedHeight = config.field_24137.method_27377();
            int topPosition = this.getTopPosition((class_3746)level, treeHeight, origin, config);
            if (topPosition >= treeHeight || clippedHeight.isPresent() && topPosition >= clippedHeight.getAsInt()) {
                if (config.rootPlacer.isPresent() && !config.rootPlacer.get().generate((class_3746)level, rootPlacerReplacer, random, pos, origin, config)) {
                    return false;
                }
                List foliage = config.field_24136.method_26991((class_3746)level, trunkPlacerReplacer, random, topPosition, origin, (class_4643)config);
                foliage.forEach(node -> config.field_24135.method_27385((class_3746)level, foliagePlacerReplacer, random, (class_4643)config, topPosition, node, foliageHeight, foliageRadius));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getTopPosition(class_3746 level, int height, class_2338 pos, RootedTreeConfig config) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int y = 0; y <= height + 1; ++y) {
            int size = config.field_24137.method_27378(height, y);
            for (int x = -size; x <= size; ++x) {
                for (int z = -size; z <= size; ++z) {
                    UpwardBranchingTrunk trunk;
                    class_5141 class_51412;
                    boolean isValid;
                    mutable.method_25504((class_2382)pos, x, y, z);
                    boolean bl = isValid = class_2944.method_27371((class_3746)level, (class_2338)pos) || level.method_16358(pos, state -> state.method_26164(class_3481.field_15475)) || (class_51412 = config.field_24136) instanceof UpwardBranchingTrunk && level.method_16358(pos, arg_0 -> RootedTreeFeature.lambda$getTopPosition$3(trunk = (UpwardBranchingTrunk)class_51412, arg_0));
                    if (isValid && (config.field_24138 || !TreeFeatureAccessor.isVine(level, (class_2338)mutable))) continue;
                    return y - 2;
                }
            }
        }
        return height;
    }

    public final boolean method_13151(class_5821<RootedTreeConfig> context) {
        class_5281 level = context.method_33652();
        Random random = context.method_33654();
        class_2338 pos = context.method_33655();
        RootedTreeConfig config = (RootedTreeConfig)context.method_33656();
        HashSet rootPos = Sets.newHashSet();
        HashSet trunkPos = Sets.newHashSet();
        HashSet foliagePos = Sets.newHashSet();
        HashSet decoratorPos = Sets.newHashSet();
        BiConsumer<class_2338, class_2680> rootReplacer = (position, state) -> {
            rootPos.add(position.method_10062());
            level.method_8652(position, state, 19);
        };
        BiConsumer<class_2338, class_2680> trunkReplacer = (position, state) -> {
            trunkPos.add(position.method_10062());
            level.method_8652(position, state, 19);
        };
        BiConsumer<class_2338, class_2680> foliageReplacer = (position, state) -> {
            foliagePos.add(position.method_10062());
            level.method_8652(position, state, 19);
        };
        BiConsumer<class_2338, class_2680> decoratorReplacer = (position, state) -> {
            decoratorPos.add(position.method_10062());
            level.method_8652(position, state, 19);
        };
        boolean generate = this.generate(level, random, pos, rootReplacer, trunkReplacer, foliageReplacer, config);
        if (!generate || trunkPos.isEmpty() && foliagePos.isEmpty()) {
            return false;
        }
        if (!config.field_21290.isEmpty()) {
            ArrayList rootPositions = Lists.newArrayList((Iterable)rootPos);
            ArrayList trunkPositions = Lists.newArrayList((Iterable)trunkPos);
            ArrayList foliagePositions = Lists.newArrayList((Iterable)foliagePos);
            trunkPositions.sort(Comparator.comparingInt(class_2382::method_10264));
            foliagePositions.sort(Comparator.comparingInt(class_2382::method_10264));
            rootPositions.sort(Comparator.comparingInt(class_2382::method_10264));
            config.field_21290.forEach(treeDecorator -> treeDecorator.method_23469((class_3746)level, decoratorReplacer, random, (List)trunkPositions, (List)foliagePositions));
        }
        return class_3341.method_35411((Iterable)Iterables.concat((Iterable)trunkPos, (Iterable)foliagePos, (Iterable)decoratorPos)).map(box -> {
            class_251 shape = RootedTreeFeature.placeLogsAndLeaves((class_1936)level, box, trunkPos, decoratorPos);
            class_3499.method_20532((class_1936)level, (int)3, (class_251)shape, (int)box.method_35415(), (int)box.method_35416(), (int)box.method_35417());
            return true;
        }).orElse(false);
    }

    private static class_251 placeLogsAndLeaves(class_1936 level, class_3341 box, Set<class_2338> trunkPositions, Set<class_2338> decoratorPositions) {
        ArrayList positions = Lists.newArrayList();
        class_244 shape = new class_244(box.method_35414(), box.method_14660(), box.method_14663());
        for (int tries = 0; tries < 6; ++tries) {
            positions.add(Sets.newHashSet());
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 pos : Lists.newArrayList(decoratorPositions)) {
            if (!box.method_14662((class_2382)pos)) continue;
            shape.method_1049(pos.method_10263() - box.method_35415(), pos.method_10264() - box.method_35416(), pos.method_10260() - box.method_35417());
        }
        for (class_2338 pos : Lists.newArrayList(trunkPositions)) {
            if (box.method_14662((class_2382)pos)) {
                shape.method_1049(pos.method_10263() - box.method_35415(), pos.method_10264() - box.method_35416(), pos.method_10260() - box.method_35417());
            }
            for (class_2350 direction : class_2350.values()) {
                class_2680 blockState;
                mutable.method_25505((class_2382)pos, direction);
                if (trunkPositions.contains(mutable) || !(blockState = level.method_8320((class_2338)mutable)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)positions.get(0)).add(mutable.method_10062());
                TreeFeatureAccessor.setBlockKnownShape((class_1945)level, (class_2338)mutable, (class_2680)blockState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!box.method_14662((class_2382)mutable)) continue;
                shape.method_1049(mutable.method_10263() - box.method_35415(), mutable.method_10264() - box.method_35416(), mutable.method_10260() - box.method_35417());
            }
        }
        for (int tries = 1; tries < 6; ++tries) {
            Set trunkPos = (Set)positions.get(tries - 1);
            Set foliagePos = (Set)positions.get(tries);
            for (class_2338 pos : trunkPos) {
                if (box.method_14662((class_2382)pos)) {
                    shape.method_1049(pos.method_10263() - box.method_35415(), pos.method_10264() - box.method_35416(), pos.method_10260() - box.method_35417());
                }
                for (class_2350 direction : class_2350.values()) {
                    mutable.method_25505((class_2382)pos, direction);
                    class_2680 state = level.method_8320((class_2338)mutable);
                    if (trunkPos.contains(mutable) || foliagePos.contains(mutable) || !state.method_28498((class_2769)class_2741.field_12541) || (Integer)state.method_11654((class_2769)class_2741.field_12541) <= tries + 1) continue;
                    class_2680 foliage = (class_2680)state.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(tries + 1));
                    TreeFeatureAccessor.setBlockKnownShape((class_1945)level, (class_2338)mutable, foliage);
                    if (box.method_14662((class_2382)mutable)) {
                        shape.method_1049(mutable.method_10263() - box.method_35415(), mutable.method_10264() - box.method_35416(), mutable.method_10260() - box.method_35417());
                    }
                    foliagePos.add(mutable.method_10062());
                }
            }
        }
        return shape;
    }

    private static /* synthetic */ boolean lambda$getTopPosition$3(UpwardBranchingTrunk trunk, class_2680 state) {
        return state.method_40143(trunk.canGrowThrough);
    }
}

