/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.features;

import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5780;
import net.minecraft.class_5821;

public class SculkGrowthFeature
extends class_3031<class_5780> {
    public SculkGrowthFeature(Codec<class_5780> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_5780> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        Random random = context.method_33654();
        class_5780 config = (class_5780)context.method_33656();
        if (!SculkGrowthFeature.isNotAirOrWater(level.method_8320(pos))) {
            List<class_2350> directions = SculkGrowthFeature.getShuffledDirections(config, random);
            if (SculkGrowthFeature.placeGrowthIfPossible(level, pos, level.method_8320(pos), config, random, directions)) {
                return true;
            }
            class_2338.class_2339 mutable = pos.method_25503();
            block0: for (class_2350 direction : directions) {
                mutable.method_10101((class_2382)pos);
                List<class_2350> filteredDirections = SculkGrowthFeature.getShuffledDirectionsExcept(config, random, direction.method_10153());
                for (int i = 0; i < config.field_28430; ++i) {
                    mutable.method_25505((class_2382)pos, direction);
                    class_2680 state = level.method_8320((class_2338)mutable);
                    if (SculkGrowthFeature.isNotAirOrWater(state) && !state.method_27852(WBBlocks.SCULK_VEIN.get())) continue block0;
                    if (!SculkGrowthFeature.placeGrowthIfPossible(level, (class_2338)mutable, state, config, random, filteredDirections)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean placeGrowthIfPossible(class_5281 level, class_2338 pos, class_2680 state, class_5780 config, Random random, List<class_2350> directions) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (class_2350 direction : directions) {
            class_2680 blockState = level.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction));
            if (!blockState.method_40143(config.field_28435)) continue;
            SculkVeinBlock veinBlock = (SculkVeinBlock)WBBlocks.SCULK_VEIN.get();
            class_2680 veinState = veinBlock.method_33362(state, (class_1922)level, pos, direction);
            if (veinState == null) {
                return false;
            }
            level.method_8652(pos, veinState, 3);
            level.method_22350(pos).method_12039(pos);
            if (random.nextFloat() < config.field_28434) {
                veinBlock.allGrowTypeGrower.grow(veinState, (class_1936)level, pos, direction, random, true);
            }
            return true;
        }
        return false;
    }

    public static List<class_2350> getShuffledDirections(class_5780 config, Random random) {
        ArrayList list = Lists.newArrayList((Iterable)config.field_28436);
        Collections.shuffle(list, random);
        return list;
    }

    public static List<class_2350> getShuffledDirectionsExcept(class_5780 config, Random random, class_2350 except) {
        List<class_2350> list = config.field_28436.stream().filter(direction -> direction != except).collect(Collectors.toList());
        Collections.shuffle(list, random);
        return list;
    }

    private static boolean isNotAirOrWater(class_2680 state) {
        return !state.method_26215() && !state.method_27852(class_2246.field_10382);
    }
}

