/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.features;

import com.cursedcauldron.wildbackport.common.blocks.SculkShriekerBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import com.cursedcauldron.wildbackport.common.worldgen.features.SculkPatchConfiguration;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class SculkPatchFeature
extends class_3031<SculkPatchConfiguration> {
    public SculkPatchFeature(Codec<SculkPatchConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<SculkPatchConfiguration> context) {
        class_2338 pos;
        class_5281 level = context.method_33652();
        if (!this.canSpreadFrom((class_1936)level, pos = context.method_33655())) {
            return false;
        }
        SculkPatchConfiguration config = (SculkPatchConfiguration)context.method_33656();
        Random random = context.method_33654();
        SculkSpreadManager spreader = SculkSpreadManager.createWorldGen();
        int rounds = config.spreadRounds() + config.growthRounds();
        for (int i = 0; i < rounds; ++i) {
            for (int count = 0; count < config.chargeCount(); ++count) {
                spreader.spread(pos, config.amountPerCharge());
            }
            boolean spreadable = i < config.spreadRounds();
            for (int attempts = 0; attempts < config.spreadAttempts(); ++attempts) {
                spreader.tick((class_1936)level, pos, random, spreadable);
            }
            spreader.clearCursors();
        }
        class_2338 catalystPos = pos.method_10074();
        if (random.nextFloat() <= config.catalystChance() && level.method_8320(catalystPos).method_26234((class_1922)level, catalystPos)) {
            level.method_8652(pos, WBBlocks.SCULK_CATALYST.get().method_9564(), 3);
        }
        int extraRareGrowths = config.extraRareGrowths().method_35008(random);
        for (int i = 0; i < extraRareGrowths; ++i) {
            class_2338 shriekPos = pos.method_10069(random.nextInt(5) - 2, 0, random.nextInt(5) - 2);
            if (!level.method_8320(shriekPos).method_26215() || !level.method_8320(shriekPos.method_10074()).method_26206((class_1922)level, shriekPos.method_10074(), class_2350.field_11036)) continue;
            level.method_8652(shriekPos, (class_2680)WBBlocks.SCULK_SHRIEKER.get().method_9564().method_11657((class_2769)SculkShriekerBlock.CAN_SUMMON, (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSpreadFrom(class_1936 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26204() instanceof SculkSpreadable) {
            return true;
        }
        if (!state.method_26215()) {
            if (!state.method_27852(class_2246.field_10382)) return false;
            if (!state.method_26227().method_15771()) return false;
        }
        if (!DirectionUtils.stream().map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).anyMatch(position -> level.method_8320(position).method_26234((class_1922)level, position))) return false;
        return true;
    }
}

