/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.placers;

import com.cursedcauldron.wildbackport.common.registry.worldgen.RootPlacerType;
import com.cursedcauldron.wildbackport.common.worldgen.decorator.AboveRootPlacement;
import com.cursedcauldron.wildbackport.common.worldgen.decorator.MangroveRootPlacement;
import com.cursedcauldron.wildbackport.common.worldgen.features.RootedTreeConfig;
import com.cursedcauldron.wildbackport.common.worldgen.placers.RootPlacer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_6017;

public class MangroveRootPlacer
extends RootPlacer {
    public static final Codec<MangroveRootPlacer> CODEC = RecordCodecBuilder.create(instance -> MangroveRootPlacer.codec(instance).and((App)MangroveRootPlacement.CODEC.fieldOf("mangrove_root_placement").forGetter(placer -> placer.mangroveRootPlacement)).apply((Applicative)instance, MangroveRootPlacer::new));
    private final MangroveRootPlacement mangroveRootPlacement;

    public MangroveRootPlacer(class_6017 trunkOffsetY, class_4651 rootProvider, Optional<AboveRootPlacement> aboveRootPlacement, MangroveRootPlacement mangroveRootPlacement) {
        super(trunkOffsetY, rootProvider, aboveRootPlacement);
        this.mangroveRootPlacement = mangroveRootPlacement;
    }

    @Override
    public boolean generate(class_3746 level, BiConsumer<class_2338, class_2680> replacer, Random random, class_2338 pos, class_2338 origin, RootedTreeConfig config) {
        ArrayList positions = Lists.newArrayList();
        class_2338.class_2339 mutable = pos.method_25503();
        while (mutable.method_10264() < origin.method_10264()) {
            if (!this.canGrowThrough(level, (class_2338)mutable)) {
                return false;
            }
            mutable.method_10098(class_2350.field_11036);
        }
        positions.add(origin.method_10074());
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            ArrayList offshootPositions;
            class_2338 position = origin.method_10093(direction);
            if (!this.canGrow(level, random, position, direction, origin, offshootPositions = Lists.newArrayList(), 0)) {
                return false;
            }
            positions.addAll(offshootPositions);
            positions.add(origin.method_10093(direction));
        }
        for (class_2338 position : positions) {
            this.placeRoots(level, replacer, random, position, config);
        }
        return true;
    }

    private boolean canGrow(class_3746 level, Random random, class_2338 pos, class_2350 direction, class_2338 origin, List<class_2338> offshootPositions, int rootLength) {
        int length = this.mangroveRootPlacement.maxRootLength();
        if (rootLength != length && offshootPositions.size() <= length) {
            for (class_2338 position : this.getOffshootPositions(pos, direction, random, origin)) {
                if (!this.canGrowThrough(level, position)) continue;
                offshootPositions.add(position);
                if (this.canGrow(level, random, position, direction, origin, offshootPositions, rootLength + 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<class_2338> getOffshootPositions(class_2338 pos, class_2350 direction, Random random, class_2338 origin) {
        class_2338 below = pos.method_10074();
        class_2338 offset = pos.method_10093(direction);
        int distance = pos.method_19455((class_2382)origin);
        int rootWidth = this.mangroveRootPlacement.maxRootWidth();
        float chance = this.mangroveRootPlacement.randomSkewChance();
        if (distance > rootWidth - 3 && distance <= rootWidth) {
            return random.nextFloat() < chance ? List.of(below, offset.method_10074()) : List.of(below);
        }
        if (distance > rootWidth) {
            return List.of(below);
        }
        if (random.nextFloat() < chance) {
            return List.of(below);
        }
        return random.nextBoolean() ? List.of(offset) : List.of(below);
    }

    @Override
    protected boolean canGrowThrough(class_3746 level, class_2338 pos) {
        return super.canGrowThrough(level, pos) || level.method_16358(pos, state -> state.method_40143(this.mangroveRootPlacement.canGrowThrough()));
    }

    @Override
    protected void placeRoots(class_3746 level, BiConsumer<class_2338, class_2680> replacer, Random random, class_2338 pos, RootedTreeConfig config) {
        if (level.method_16358(pos, state -> state.method_40143(this.mangroveRootPlacement.muddyRootsIn()))) {
            class_2680 state2 = this.mangroveRootPlacement.muddyRootsProvider().method_23455(random, pos);
            replacer.accept(pos, this.applyWaterlogging(level, pos, state2));
        } else {
            super.placeRoots(level, replacer, random, pos, config);
        }
    }

    @Override
    protected RootPlacerType<?> getType() {
        return RootPlacerType.MANGROVE_ROOT_PLACER.get();
    }
}

