/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.placers;

import com.cursedcauldron.wildbackport.common.registry.WBRegistries;
import com.cursedcauldron.wildbackport.common.registry.worldgen.RootPlacerType;
import com.cursedcauldron.wildbackport.common.worldgen.decorator.AboveRootPlacement;
import com.cursedcauldron.wildbackport.common.worldgen.features.RootedTreeConfig;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3486;
import net.minecraft.class_3746;
import net.minecraft.class_4651;
import net.minecraft.class_4970;
import net.minecraft.class_6017;

public abstract class RootPlacer {
    public static final Codec<RootPlacer> CODEC = WBRegistries.ROOT_PLACER_TYPES.registry().method_39673().dispatch(RootPlacer::getType, RootPlacerType::codec);
    protected final class_6017 trunkOffsetY;
    protected final class_4651 rootProvider;
    protected final Optional<AboveRootPlacement> aboveRootPlacement;

    protected static <P extends RootPlacer> Products.P3<RecordCodecBuilder.Mu<P>, class_6017, class_4651, Optional<AboveRootPlacement>> codec(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)class_6017.field_29946.fieldOf("trunk_offset_y").forGetter(placer -> placer.trunkOffsetY), (App)class_4651.field_24937.fieldOf("root_provider").forGetter(placer -> placer.rootProvider), (App)AboveRootPlacement.CODEC.optionalFieldOf("above_root_placement").forGetter(placer -> placer.aboveRootPlacement));
    }

    public RootPlacer(class_6017 trunkOffsetY, class_4651 rootProvider, Optional<AboveRootPlacement> aboveRootPlacement) {
        this.trunkOffsetY = trunkOffsetY;
        this.rootProvider = rootProvider;
        this.aboveRootPlacement = aboveRootPlacement;
    }

    protected abstract RootPlacerType<?> getType();

    public abstract boolean generate(class_3746 var1, BiConsumer<class_2338, class_2680> var2, Random var3, class_2338 var4, class_2338 var5, RootedTreeConfig var6);

    protected boolean canGrowThrough(class_3746 level, class_2338 pos) {
        return class_2944.method_27371((class_3746)level, (class_2338)pos);
    }

    protected void placeRoots(class_3746 level, BiConsumer<class_2338, class_2680> replacer, Random random, class_2338 pos, RootedTreeConfig config) {
        if (this.canGrowThrough(level, pos)) {
            replacer.accept(pos, this.applyWaterlogging(level, pos, this.rootProvider.method_23455(random, pos)));
            if (this.aboveRootPlacement.isPresent()) {
                AboveRootPlacement placement = this.aboveRootPlacement.get();
                class_2338 above = pos.method_10084();
                if (random.nextFloat() < placement.aboveRootPlacementChance() && level.method_16358(above, class_4970.class_4971::method_26215)) {
                    replacer.accept(above, this.applyWaterlogging(level, above, placement.aboveRootProvider().method_23455(random, above)));
                }
            }
        }
    }

    protected class_2680 applyWaterlogging(class_3746 level, class_2338 pos, class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12508) ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(level.method_35237(pos, fluid -> fluid.method_15767(class_3486.field_15517)))) : state;
    }

    public class_2338 trunkOffset(class_2338 pos, Random random) {
        return pos.method_10086(this.trunkOffsetY.method_35008(random));
    }
}

