/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.placers;

import com.cursedcauldron.wildbackport.common.registry.worldgen.WBTrunkPlacers;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5321;
import net.minecraft.class_6017;
import net.minecraft.class_6885;
import net.minecraft.class_6895;

public class UpwardBranchingTrunk
extends class_5141 {
    public static final Codec<UpwardBranchingTrunk> CODEC = RecordCodecBuilder.create(instance -> UpwardBranchingTrunk.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.field_33451.fieldOf("extra_branch_steps").forGetter(placer -> placer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(placer -> Float.valueOf(placer.placeBranchPerLogProbability)), (App)class_6017.field_33450.fieldOf("extra_branch_length").forGetter(placer -> placer.extraBranchLength), (App)class_6895.method_40340((class_5321)class_2378.field_25105).fieldOf("can_grow_through").forGetter(placer -> placer.canGrowThrough))).apply((Applicative)instance, UpwardBranchingTrunk::new));
    private final class_6017 extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final class_6017 extraBranchLength;
    public final class_6885<class_2248> canGrowThrough;

    public UpwardBranchingTrunk(int baseHeight, int firstRandomHeight, int secondRandomHeight, class_6017 extraBranchSteps, float placeBranchPerLogProbability, class_6017 extraBranchLength, class_6885<class_2248> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
        this.canGrowThrough = canGrowThrough;
    }

    public List<class_4647.class_5208> method_26991(class_3746 level, BiConsumer<class_2338, class_2680> replacer, Random random, int height, class_2338 startPos, class_4643 config) {
        ArrayList attachments = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i < height; ++i) {
            int yOffset = startPos.method_10264() + i;
            if (UpwardBranchingTrunk.method_35375((class_3746)level, replacer, (Random)random, (class_2338)mutable.method_10103(startPos.method_10263(), yOffset, startPos.method_10260()), (class_4643)config) && i < height - 1 && random.nextFloat() < this.placeBranchPerLogProbability) {
                class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
                int offset = this.extraBranchLength.method_35008(random);
                int length = Math.max(0, offset - this.extraBranchLength.method_35008(random) - 1);
                int steps = this.extraBranchSteps.method_35008(random);
                this.placeBranch(level, replacer, random, height, config, attachments, mutable, yOffset, direction, length, steps);
            }
            if (i != height - 1) continue;
            attachments.add(new class_4647.class_5208((class_2338)mutable.method_10103(startPos.method_10263(), yOffset + 1, startPos.method_10260()), 0, false));
        }
        return attachments;
    }

    private void placeBranch(class_3746 level, BiConsumer<class_2338, class_2680> replacer, Random random, int height, class_4643 config, List<class_4647.class_5208> attachments, class_2338.class_2339 mutable, int yOffset, class_2350 direction, int length, int steps) {
        int y = yOffset + length;
        int x = mutable.method_10263();
        int z = mutable.method_10260();
        for (int l = length; l < height && steps > 0; ++l, --steps) {
            if (l < 1) continue;
            int offset = yOffset + l;
            y = offset;
            if (UpwardBranchingTrunk.method_35375((class_3746)level, replacer, (Random)random, (class_2338)mutable.method_10103(x += direction.method_10148(), offset, z += direction.method_10165()), (class_4643)config)) {
                y = offset + 1;
            }
            attachments.add(new class_4647.class_5208(mutable.method_10062(), 0, false));
        }
        if (y - yOffset > 1) {
            class_2338 pos = new class_2338(x, y, z);
            attachments.add(new class_4647.class_5208(pos, 0, false));
            attachments.add(new class_4647.class_5208(pos.method_10087(2), 0, false));
        }
    }

    protected class_5142<?> method_28903() {
        return WBTrunkPlacers.UPWARDS_BRANCHING_TRUNK.get();
    }
}

