/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.common.level.worldgen.biome;

import com.blackgear.cavebiomeapi.common.level.worldgen.biome.ParentBasedBiomeSource;
import com.blackgear.cavebiomeapi.common.level.worldgen.biome.debug.DebugBiomeBuilder;
import com.blackgear.cavebiomeapi.core.mixin.MultiNoiseBiomeSourceAccessor;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraft.world.server.ServerWorld;

public class CaveBiomeBuilder {
    private static final Multimap<ResourceLocation, Biome.Attributes> NOISE_PARAMETERS = HashMultimap.create();

    public static synchronized void addUndergroundBiome(ResourceLocation biome, Biome.Attributes parameters) {
        NOISE_PARAMETERS.put((Object)biome, (Object)parameters);
    }

    public static synchronized void addUndergroundBiome(RegistryKey<Biome> biome, Biome.Attributes parameters) {
        NOISE_PARAMETERS.put((Object)biome.func_240901_a_(), (Object)parameters);
    }

    public static synchronized void addUndergroundBiome(ResourceLocation biome, Supplier<Block> block, Biome.Attributes parameters) {
        CaveBiomeBuilder.addUndergroundBiome(biome, parameters);
        DebugBiomeBuilder.addDebugBlock(block, parameters);
    }

    public static synchronized void addUndergroundBiome(RegistryKey<Biome> biome, Supplier<Block> block, Biome.Attributes parameters) {
        CaveBiomeBuilder.addUndergroundBiome(biome, parameters);
        DebugBiomeBuilder.addDebugBlock(block, parameters);
    }

    public static synchronized boolean isUndergroundBiome(ResourceLocation biome) {
        return NOISE_PARAMETERS.containsKey((Object)biome);
    }

    public static synchronized boolean findBiomeWithPredicate(Predicate<Biome> predicate) {
        return NOISE_PARAMETERS.keys().stream().map(arg_0 -> ((Registry)WorldGenRegistries.field_243657_i).func_82594_a(arg_0)).anyMatch(biome -> biome != null && predicate.test((Biome)biome));
    }

    public static synchronized ParentBasedBiomeSource create(ServerWorld level, BiomeProvider parent, Registry<Biome> biomes, long seed) {
        ArrayList<Pair<Biome.Attributes, Supplier<Biome>>> entries = new ArrayList<Pair<Biome.Attributes, Supplier<Biome>>>();
        NOISE_PARAMETERS.forEach((key, parameters) -> {
            Optional biome = biomes.func_241873_b(key);
            biome.ifPresent(entry -> entries.add(Pair.of((Object)parameters, () -> entry)));
        });
        return new ParentBasedBiomeSource(level, parent, seed, entries);
    }

    public static synchronized NetherBiomeProvider createLegacy(Registry<Biome> biomes, long seed) {
        ArrayList<Pair<Biome.Attributes, Supplier<Biome>>> entries = new ArrayList<Pair<Biome.Attributes, Supplier<Biome>>>();
        NOISE_PARAMETERS.forEach((key, parameters) -> {
            Optional biome = biomes.func_241873_b(key);
            biome.ifPresent(entry -> entries.add(Pair.of((Object)parameters, () -> entry)));
        });
        NetherBiomeProvider.Noise temperature = CaveBiomeBuilder.parameters(-9, 1.0, 0.0, 3.0, 3.0, 3.0, 3.0);
        NetherBiomeProvider.Noise humidity = CaveBiomeBuilder.parameters(-7, 1.0, 2.0, 4.0, 4.0);
        NetherBiomeProvider.Noise altitude = CaveBiomeBuilder.parameters(-9, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        NetherBiomeProvider.Noise weirdness = CaveBiomeBuilder.parameters(-8, 1.2, 0.6, 0.0, 0.0, 1.0, 0.0);
        return MultiNoiseBiomeSourceAccessor.create(seed, entries, temperature, humidity, altitude, weirdness);
    }

    private static NetherBiomeProvider.Noise parameters(int octaves, double ... amplitudes) {
        return new NetherBiomeProvider.Noise(octaves, (List)new DoubleArrayList(amplitudes));
    }
}

