/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.common.level.worldgen.biome;

import com.blackgear.cavebiomeapi.common.level.worldgen.biome.CaveBiomeBuilder;
import com.blackgear.cavebiomeapi.core.CaveBiomeAPI;
import com.blackgear.cavebiomeapi.core.Utilities;
import com.blackgear.platform.core.util.WorldGenUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;

public class CaveBiomeSource {
    private final BiomeProvider parent;
    private final BiomeProvider undergroundBiomeSource;

    public CaveBiomeSource(ServerWorld level, BiomeProvider parent, Registry<Biome> biomes, long seed) {
        this.parent = parent;
        this.undergroundBiomeSource = (Boolean)CaveBiomeAPI.CONFIG.useExperimentalBiomeSource.get() != false ? CaveBiomeBuilder.create(level, parent, biomes, seed) : CaveBiomeBuilder.createLegacy(biomes, seed);
    }

    public BiomeProvider getUndergroundBiomeSource() {
        return this.undergroundBiomeSource;
    }

    public Biome getSurfaceBiome(int x, int y, int z) {
        return this.parent.func_225526_b_(x, y, z);
    }

    public Biome getUndergroundBiome(int x, int y, int z) {
        return this.undergroundBiomeSource.func_225526_b_(x, y, z);
    }

    public void applyUndergroundBiomeDecoration(ChunkGenerator generator, WorldGenRegion region) {
        int centerX = region.func_201679_a();
        int centerZ = region.func_201680_b();
        int x = centerX * 16;
        int z = centerZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.getUndergroundBiome((centerX << 2) + 2, 5, (centerZ << 2) + 2);
        if (CaveBiomeBuilder.isUndergroundBiome(Utilities.registryName(biome))) {
            SharedSeedRandom random = new SharedSeedRandom();
            long seed = random.func_202426_b(region.func_72905_C(), x, z);
            try {
                this.generateOnlyFeatures(biome, generator, region, seed, random, pos);
            }
            catch (Exception exception) {
                CrashReport report = CrashReport.func_85055_a((Throwable)exception, (String)"Underground feature decoration");
                report.func_85058_a("Generation").func_71507_a("CenterX", (Object)centerX).func_71507_a("CenterZ", (Object)centerZ).func_71507_a("Seed", (Object)seed).func_71507_a("Biome", (Object)biome);
                throw new ReportedException(report);
            }
        }
    }

    private void generateOnlyFeatures(Biome biome, ChunkGenerator generator, WorldGenRegion region, long seed, SharedSeedRandom random, BlockPos pos) {
        List features = biome.func_242440_e().func_242498_c();
        int decorators = GenerationStage.Decoration.values().length;
        for (int i = 0; i < decorators; ++i) {
            int featureIndex = 1001;
            if (features.size() <= i) continue;
            for (Supplier feature : (List)features.get(i)) {
                ConfiguredFeature configured = (ConfiguredFeature)feature.get();
                random.func_202426_b(seed, featureIndex, i);
                try {
                    configured.func_242765_a((ISeedReader)region, generator, (Random)random, pos);
                }
                catch (Exception exception) {
                    CrashReport report = CrashReport.func_85055_a((Throwable)exception, (String)"Underground feature placement");
                    report.func_85058_a("Feature").func_71507_a("Id", (Object)Registry.field_218379_q.func_148757_b((Object)configured.field_222737_a)).func_71507_a("Config", (Object)configured.field_222738_b).func_71507_a("Description", (Object)configured.field_222737_a.toString());
                    throw new ReportedException(report);
                }
            }
        }
    }

    public void createUndergroundBiomes(ChunkGenerator generator, Registry<Biome> biomes, IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        ((ChunkPrimer)chunk).func_225548_a_(new BiomeContainer(biomes, chunkPos, (BiomeProvider)new UndergroundBiomeSource(generator, chunk)));
    }

    private final class UndergroundBiomeSource
    extends BiomeProvider {
        private final ChunkGenerator generator;
        private final IChunk chunk;

        public UndergroundBiomeSource(ChunkGenerator generator, IChunk chunk) {
            super(CaveBiomeSource.this.parent.func_235203_c_());
            this.generator = generator;
            this.chunk = chunk;
        }

        public Biome func_225526_b_(int x, int y, int z) {
            Biome biome;
            double factor = (double)y * 4.0;
            int height = WorldGenUtils.getUndergroundGenerationHeight((int)this.generator.func_230356_f_(), (int)this.chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z));
            if (factor <= (double)height && !Utilities.compare((RegistryKey<Biome>)Biomes.field_185440_P, biome = CaveBiomeSource.this.getUndergroundBiome(x, y, z))) {
                return biome;
            }
            return CaveBiomeSource.this.getSurfaceBiome(x, y, z);
        }

        protected Codec<? extends BiomeProvider> func_230319_a_() {
            return Codec.unit((Object)((Object)this));
        }

        public BiomeProvider func_230320_a_(long seed) {
            return this;
        }
    }
}

