/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.common.level.worldgen.biome;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.server.ServerWorld;

public class ParentBasedBiomeSource
extends BiomeProvider {
    private final BiomeProvider parent;
    private final ServerWorld level;
    private final List<Pair<Biome.Attributes, Supplier<Biome>>> parameters;
    private final PerlinNoiseGenerator weirdness;
    private final PerlinNoiseGenerator offset;
    private Biome.Attributes climate;

    protected ParentBasedBiomeSource(ServerWorld level, BiomeProvider parent, long seed, List<Pair<Biome.Attributes, Supplier<Biome>>> parameters) {
        super(parameters.stream().map(Pair::getSecond));
        this.level = level;
        this.parent = parent;
        this.weirdness = new PerlinNoiseGenerator(new SharedSeedRandom(seed), IntStream.rangeClosed(-8, 0));
        this.offset = new PerlinNoiseGenerator(new SharedSeedRandom(seed + 1L), IntStream.rangeClosed(-8, 0));
        this.parameters = parameters;
    }

    public void updateClimate(Biome biome, int x, int z) {
        float temperature = ParentBasedBiomeSource.clamp(biome.func_242445_k() * 2.0f - 1.0f);
        float humidity = ParentBasedBiomeSource.clamp(biome.func_76727_i() * 2.0f - 1.0f);
        float altitude = ParentBasedBiomeSource.clamp(biome.func_185355_j() * 1.25f);
        this.climate = new Biome.Attributes(temperature, humidity, altitude, (float)this.weirdness.func_215464_a((double)x, (double)z, false), (float)this.offset.func_215464_a((double)x, (double)z, false));
    }

    public Biome func_225526_b_(int x, int y, int z) {
        Biome biome = this.parent.func_225526_b_(x, y, z);
        this.updateClimate(biome, x, z);
        return this.parameters.stream().min(Comparator.comparing(pair -> Float.valueOf(((Biome.Attributes)pair.getFirst()).func_235110_a_(this.climate)))).map(Pair::getSecond).map(Supplier::get).orElse(BiomeRegistry.field_244201_b);
    }

    private static float clamp(float attribute) {
        return (float)MathHelper.func_151237_a((double)attribute, (double)-2.0, (double)2.0);
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new ParentBasedBiomeSource(this.level, this.parent, seed, this.parameters);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return Codec.unit((Object)((Object)this));
    }
}

