/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomeapi.core.mixin.common;

import com.blackgear.cavebiomeapi.common.level.worldgen.biome.BiomeTargetSelector;
import com.blackgear.cavebiomeapi.common.level.worldgen.biome.CaveBiomeBuilder;
import com.blackgear.cavebiomeapi.common.level.worldgen.biome.CaveBiomeHolder;
import com.blackgear.cavebiomeapi.common.level.worldgen.biome.CaveBiomeSource;
import com.blackgear.cavebiomeapi.core.CaveBiomeAPI;
import com.blackgear.cavebiomeapi.core.Utilities;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeProvider.class})
public abstract class BiomeSourceMixin
implements CaveBiomeHolder {
    @Unique
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    @Unique
    private Optional<CaveBiomeSource> caveBiomeSource = Optional.empty();

    @Override
    public void generateCaveBiomeSource(ServerWorld level) {
        if (this.initialized.compareAndSet(false, true) && CaveBiomeAPI.isDimensionWhitelisted(level.func_234923_W_().func_240901_a_())) {
            MutableRegistry biomes = level.func_241828_r().func_243612_b(Registry.field_239720_u_);
            this.caveBiomeSource = Optional.of(new CaveBiomeSource(level, (BiomeProvider)this, (Registry<Biome>)biomes, level.func_72905_C()));
        }
    }

    @Override
    public Optional<CaveBiomeSource> getCaveBiomeSource() {
        return this.caveBiomeSource;
    }

    @Inject(method={"findBiomeHorizontal(IIIIILjava/util/function/Predicate;Ljava/util/Random;Z)Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void locateUndergroundBiome(int x, int y, int z, int radius, int increment, Predicate<Biome> biomes, Random random, boolean findClosest, CallbackInfoReturnable<BlockPos> cir) {
        if (!(biomes instanceof BiomeTargetSelector)) {
            return;
        }
        BiomeTargetSelector selector = (BiomeTargetSelector)biomes;
        this.locateUndergroundBiome(source -> CaveBiomeBuilder.isUndergroundBiome(Utilities.registryName(selector.target)), x, y, z, radius, increment, biomes, random, findClosest, cir);
    }

    @Inject(method={"findBiomeHorizontal(IIIIILjava/util/function/Predicate;Ljava/util/Random;Z)Lnet/minecraft/core/BlockPos;"}, at={@At(value="TAIL")}, cancellable=true)
    private void locateUndergroundBiomeFallback(int x, int y, int z, int radius, int increment, Predicate<Biome> biomes, Random random, boolean findClosest, CallbackInfoReturnable<BlockPos> cir) {
        if (cir.getReturnValue() == null && !(biomes instanceof BiomeTargetSelector)) {
            this.locateUndergroundBiome(source -> CaveBiomeBuilder.findBiomeWithPredicate(biomes), x, y, z, radius, increment, biomes, random, findClosest, cir);
        }
    }

    @Unique
    private void locateUndergroundBiome(Predicate<CaveBiomeSource> predicate, int x, int y, int z, int radius, int increment, Predicate<Biome> biomes, Random random, boolean findClosest, CallbackInfoReturnable<BlockPos> cir) {
        this.caveBiomeSource.filter(predicate).ifPresent(source -> cir.setReturnValue((Object)source.getUndergroundBiomeSource().func_230321_a_(x, y, z, radius, increment, biomes, random, findClosest)));
    }
}

