/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.events;

import com.blackgear.cavesandcliffs.common.entity.IFreezeable;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.mixin.core.accessor.IngameGuiAccessor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class PowderSnowRenderEvent {
    private static final ResourceLocation POWDER_SNOW_OUTLINE = new ResourceLocation("cavesandcliffs", "textures/misc/powder_snow_outline.png");
    private static final ResourceLocation FROZEN_HEART_TEXTURE = new ResourceLocation("cavesandcliffs", "textures/gui/frozen_gui.png");

    @SubscribeEvent
    public static void renderFrozenOverlay(RenderGameOverlayEvent.Post event) {
        MainWindow res = event.getWindow();
        if (event.getType() == RenderGameOverlayEvent.ElementType.VIGNETTE && Minecraft.func_71410_x().field_71439_g != null && ((IFreezeable)Minecraft.func_71410_x().field_71439_g).getFrozenTicks() > 0) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableAlphaTest();
            RenderSystem.alphaFunc((int)516, (float)0.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((IFreezeable)Minecraft.func_71410_x().field_71439_g).getFreezingScale());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(POWDER_SNOW_OUTLINE);
            AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)res.func_198107_o(), (int)res.func_198087_p(), (int)res.func_198107_o(), (int)res.func_198087_p());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public static void fogDensity(EntityViewRenderEvent.FogDensity event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockState state = event.getInfo().getBlockAtCamera();
        if (player == null) {
            return;
        }
        if (player.func_175149_v() && player.func_208600_a((ITag)FluidTags.field_206960_b)) {
            event.setDensity(0.0225f);
            event.setCanceled(true);
        }
        if (state.func_203425_a((Block)CCBBlocks.POWDER_SNOW.get())) {
            if (player.func_175149_v()) {
                event.setDensity(0.0225f);
            } else {
                event.setDensity(1.0f);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void fogColors(EntityViewRenderEvent.FogColors event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockState state = event.getInfo().getBlockAtCamera();
        if (player == null) {
            return;
        }
        if (state.func_203425_a((Block)CCBBlocks.POWDER_SNOW.get())) {
            event.setRed(0.623f);
            event.setGreen(0.734f);
            event.setBlue(0.785f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderFrozenHearts(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || event.isCanceled()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        MainWindow res = Minecraft.func_71410_x().func_228018_at_();
        int width = res.func_198107_o() / 2 - 91;
        int height = res.func_198087_p() - 39;
        if (player != null && ((IFreezeable)player).isFreezing()) {
            PowderSnowRenderEvent.drawFrozenHearts((PlayerEntity)player, event.getMatrixStack(), width, height);
        }
    }

    public static void drawFrozenHearts(PlayerEntity player, MatrixStack matrixStack, int width, int height) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.01);
        IngameGui gui = Minecraft.func_71410_x().field_71456_v;
        Objects.requireNonNull(player);
        float playerHealth = player.func_110143_aJ();
        int ticks = gui.func_73834_c();
        Random random = new Random();
        random.setSeed((long)ticks * 312871L);
        float absorption = MathHelper.func_76123_f((float)player.func_110139_bj());
        boolean shouldHighlight = ((IngameGuiAccessor)gui).getHealthUpdateCounter() > (long)ticks && (((IngameGuiAccessor)gui).getHealthUpdateCounter() - (long)ticks) / 3L % 2L == 1L;
        int healthRows = MathHelper.func_76123_f((float)((player.func_110138_aP() + absorption) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int regeneration = -1;
        if (player.func_70644_a(Effects.field_76428_l)) {
            regeneration = ticks % 25;
        }
        int vOffset = 9 * (Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e).func_72912_H().func_76093_s() ? 1 : 0);
        int uOffset = shouldHighlight ? 9 : 0;
        float currentAbsorption = absorption;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FROZEN_HEART_TEXTURE);
        RenderSystem.enableBlend();
        for (int i = MathHelper.func_76123_f((float)((player.func_110138_aP() + absorption) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = width + i % 10 * 8;
            int y = height - row * rowHeight;
            if (playerHealth <= 4.0f) {
                y += random.nextInt(2);
            }
            if (i == regeneration) {
                y -= 2;
            }
            gui.func_238474_b_(matrixStack, x, y, uOffset, vOffset, 9, 9);
            if (shouldHighlight) {
                if (i * 2 + 1 < ((IngameGuiAccessor)gui).getLastPlayerHealth()) {
                    gui.func_238474_b_(matrixStack, x, y, 54, vOffset, 9, 9);
                } else if (i * 2 + 1 == ((IngameGuiAccessor)gui).getLastPlayerHealth()) {
                    gui.func_238474_b_(matrixStack, x, y, 63, vOffset, 9, 9);
                }
            }
            if (currentAbsorption > 0.0f) {
                if (currentAbsorption == absorption && absorption % 2.0f == 1.0f) {
                    gui.func_238474_b_(matrixStack, x, y, 63, vOffset, 9, 9);
                    currentAbsorption -= 1.0f;
                    continue;
                }
                gui.func_238474_b_(matrixStack, x, y, 54, vOffset, 9, 9);
                currentAbsorption -= 2.0f;
                continue;
            }
            if ((float)(i * 2 + 1) < playerHealth) {
                gui.func_238474_b_(matrixStack, x, y, 36, vOffset, 9, 9);
                continue;
            }
            if ((float)(i * 2 + 1) != playerHealth) continue;
            gui.func_238474_b_(matrixStack, x, y, 45, vOffset, 9, 9);
        }
        RenderSystem.disableBlend();
        matrixStack.func_227865_b_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }
}

