/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks.enums;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public enum VerticalSlabType implements IStringSerializable
{
    NORTH(Direction.NORTH),
    SOUTH(Direction.SOUTH),
    WEST(Direction.WEST),
    EAST(Direction.EAST),
    DOUBLE(null);

    private final String name;
    public final Direction direction;
    public final VoxelShape shape;

    private VerticalSlabType(Direction direction) {
        this.name = direction == null ? "double" : direction.func_176610_l();
        this.direction = direction;
        if (direction == null) {
            this.shape = VoxelShapes.func_197868_b();
        } else {
            double min = 0.0;
            double max = 8.0;
            if (direction.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
                min = 8.0;
                max = 16.0;
            }
            this.shape = direction.func_176740_k() == Direction.Axis.X ? Block.func_208617_a((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.func_208617_a((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
        }
    }

    public String toString() {
        return this.name;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public static VerticalSlabType fromDirection(Direction direction) {
        for (VerticalSlabType type : VerticalSlabType.values()) {
            if (type.direction == null || direction != type.direction) continue;
            return type;
        }
        return null;
    }
}

