/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.blocks.ILandingBlock;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import java.util.function.Predicate;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CCBFallingBlockEntity
extends Entity {
    private BlockState fallTile = ((Block)CCBBlocks.POINTED_DRIPSTONE.get()).func_176223_P();
    public int fallTime;
    public boolean shouldDropItem = true;
    private boolean dontSetBlock;
    private boolean hurtEntities;
    private int fallHurtMax = 40;
    private float fallHurtAmount;
    public CompoundNBT tileEntityData;
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(CCBFallingBlockEntity.class, (IDataSerializer)DataSerializers.field_187200_j);

    public CCBFallingBlockEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public CCBFallingBlockEntity(World world, double x, double y, double z, BlockState fallTile) {
        this((EntityType)CCBEntityTypes.FALLING_BLOCK.get(), world);
        this.fallTile = fallTile;
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.setOrigin(this.func_233580_cy_());
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setOrigin(BlockPos origin) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)origin);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        if (this.fallTile.func_196958_f()) {
            this.func_70106_y();
        } else {
            BlockPos pos;
            Block block = this.fallTile.func_177230_c();
            if (this.fallTime++ == 0) {
                pos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(pos).func_203425_a(block)) {
                    this.field_70170_p.func_217377_a(pos, false);
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult hit;
                pos = this.func_233580_cy_();
                boolean isConcretePowder = this.fallTile.func_177230_c() instanceof ConcretePowderBlock;
                boolean isConcreteTouchingWater = isConcretePowder && this.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
                double distance = this.func_213322_ci().func_189985_c();
                if (isConcretePowder && distance > 1.0 && (hit = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), this.func_213303_ch(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS && this.field_70170_p.func_204610_c(hit.func_216350_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    pos = hit.func_216350_a();
                    isConcreteTouchingWater = true;
                }
                if (!this.field_70122_E && !isConcreteTouchingWater) {
                    if (!(this.field_70170_p.field_72995_K || (this.fallTime <= 100 || pos.func_177956_o() >= 1 && pos.func_177956_o() <= 256) && this.fallTime <= 600)) {
                        if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)block);
                        }
                        this.func_70106_y();
                    }
                } else {
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                    if (!state.func_203425_a(Blocks.field_196603_bb)) {
                        this.func_70106_y();
                        if (!this.dontSetBlock) {
                            boolean isInValidPosition;
                            boolean flag2 = state.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, pos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                            boolean flag3 = FallingBlock.func_185759_i((BlockState)this.field_70170_p.func_180495_p(pos.func_177977_b())) && (!isConcretePowder || !isConcreteTouchingWater);
                            boolean bl = isInValidPosition = this.fallTile.func_196955_c((IWorldReader)this.field_70170_p, pos) && !flag3;
                            if (flag2 && isInValidPosition) {
                                if (this.fallTile.func_235901_b_((Property)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a) {
                                    this.fallTile = (BlockState)this.fallTile.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.TRUE);
                                }
                                if (this.field_70170_p.func_180501_a(pos, this.fallTile, 3)) {
                                    TileEntity tileEntity;
                                    this.func_70106_y();
                                    if (block instanceof ILandingBlock) {
                                        ((ILandingBlock)block).onLanding(this.field_70170_p, pos, this.fallTile, state, this);
                                    }
                                    if (this.tileEntityData != null && this.fallTile.hasTileEntity() && (tileEntity = this.field_70170_p.func_175625_s(pos)) != null) {
                                        CompoundNBT compoundnbt = tileEntity.func_189515_b(new CompoundNBT());
                                        for (String data : this.tileEntityData.func_150296_c()) {
                                            INBT inbt = this.tileEntityData.func_74781_a(data);
                                            if ("x".equals(data) || "y".equals(data) || "z".equals(data)) continue;
                                            compoundnbt.func_218657_a(data, inbt.func_74737_b());
                                        }
                                        try {
                                            tileEntity.func_230337_a_(this.fallTile, compoundnbt);
                                        }
                                        catch (Exception exception) {
                                            field_184243_a.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileEntity.func_70296_d();
                                    }
                                } else if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                    this.func_70106_y();
                                    this.onDestroyedOnLanding(block, pos);
                                    this.func_199703_a((IItemProvider)block);
                                }
                            } else {
                                this.func_70106_y();
                                if (this.shouldDropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                    this.onDestroyedOnLanding(block, pos);
                                    this.func_199703_a((IItemProvider)block);
                                }
                            }
                        } else {
                            this.func_70106_y();
                            this.onDestroyedOnLanding(block, pos);
                        }
                    }
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    public void onDestroyedOnLanding(Block block, BlockPos pos) {
        if (block instanceof ILandingBlock) {
            ((ILandingBlock)block).onDestroyedOnLanding(this.field_70170_p, pos, this);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        DamageSource damageSource;
        Predicate<Entity> predicate;
        if (!this.hurtEntities) {
            return false;
        }
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (i < 0) {
            return false;
        }
        if (this.fallTile.func_177230_c() instanceof ILandingBlock) {
            ILandingBlock landingBlock = (ILandingBlock)this.fallTile.func_177230_c();
            predicate = landingBlock.getEntityPredicate();
            damageSource = landingBlock.getDamageSource();
        } else {
            predicate = EntityPredicates.field_180132_d;
            damageSource = DamageSource.field_82729_p;
        }
        float amount = Math.min(MathHelper.func_76141_d((float)((float)i * this.fallHurtAmount)), this.fallHurtMax);
        this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), predicate).forEach(entity -> entity.func_70097_a(damageSource, amount));
        boolean isAnvilBlock = this.fallTile.func_235714_a_((ITag)BlockTags.field_200572_k);
        if (isAnvilBlock && amount > 0.0f && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
            BlockState blockstate = AnvilBlock.func_196433_f((BlockState)this.fallTile);
            if (blockstate == null) {
                this.dontSetBlock = true;
            } else {
                this.fallTile = blockstate;
            }
        }
        return false;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.fallTile));
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74757_a("DropItem", this.shouldDropItem);
        compound.func_74757_a("HurtEntities", this.hurtEntities);
        compound.func_74776_a("FallHurtAmount", this.fallHurtAmount);
        compound.func_74768_a("FallHurtMax", this.fallHurtMax);
        if (this.tileEntityData != null) {
            compound.func_218657_a("TileEntityData", (INBT)this.tileEntityData);
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.fallTile = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState"));
        this.fallTime = compound.func_74762_e("Time");
        if (compound.func_150297_b("HurtEntities", 99)) {
            this.hurtEntities = compound.func_74767_n("HurtEntities");
            this.fallHurtAmount = compound.func_74760_g("FallHurtAmount");
            this.fallHurtMax = compound.func_74762_e("FallHurtMax");
        } else if (this.fallTile.func_235714_a_((ITag)BlockTags.field_200572_k)) {
            this.hurtEntities = true;
        }
        if (compound.func_150297_b("DropItem", 99)) {
            this.shouldDropItem = compound.func_74767_n("DropItem");
        }
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.tileEntityData = compound.func_74775_l("TileEntityData");
        }
        if (this.fallTile.func_196958_f()) {
            this.fallTile = Blocks.field_150354_m.func_176223_P();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public World getWorldObj() {
        return this.field_70170_p;
    }

    public void setHurtEntities(float fallHurtAmount, int fallHurtMax) {
        this.hurtEntities = true;
        this.fallHurtAmount = fallHurtAmount;
        this.fallHurtMax = fallHurtMax;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void func_85029_a(CrashReportCategory category) {
        super.func_85029_a(category);
        category.func_71507_a("Immitating BlockState", (Object)this.fallTile.toString());
    }

    public BlockState getBlockState() {
        return this.fallTile;
    }

    public boolean func_184213_bq() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this, Block.func_196246_j((BlockState)this.getBlockState()));
    }
}

