/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events;

import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.common.world.VanillaBiomeFeatures;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBBiomes;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBSurfaceBuilders;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GlobalBiomeFeatures {
    @SubscribeEvent
    public static void onGlobalBiomeLoad(BiomeLoadingEvent event) {
        GlobalBiomeManager manager = new GlobalBiomeManager(event);
        if (!manager.canGenerate()) {
            return;
        }
        if (manager.isIn(Biome.Category.OCEAN)) {
            BiomeFeatures.generateCaveFeatures(manager, true);
        } else {
            BiomeFeatures.generateCaveFeatures(manager);
        }
    }

    @SubscribeEvent
    public static void onCaveBiomeLoad(BiomeLoadingEvent event) {
        GlobalBiomeManager manager = new GlobalBiomeManager(event);
        if (manager.isIn((Biome)CCBBiomes.DRIPSTONE_CAVES.get())) {
            BiomeFeatures.generateDripstoneFeatures(manager);
        }
        if (manager.isIn((Biome)CCBBiomes.LUSH_CAVES.get())) {
            BiomeFeatures.generateLushCaveFeatures(manager);
        }
    }

    @SubscribeEvent
    public static void onCliffBiomeLoad(BiomeLoadingEvent event) {
        GlobalBiomeManager manager = new GlobalBiomeManager(event);
        if (manager.isIn((Biome)CCBBiomes.MEADOW.get())) {
            VanillaBiomeFeatures.addMeadowFlowers(manager.generation());
        }
        if (manager.isIn((RegistryKey<Biome>)Biomes.field_150576_N)) {
            manager.generation().func_242517_a(CCBSurfaceBuilders.Configured.STONE_SHORE);
        }
        if (manager.isIn((Biome)CCBBiomes.FROZEN_PEAKS.get()) || manager.isIn((Biome)CCBBiomes.SNOWY_SLOPES.get()) || manager.isIn((Biome)CCBBiomes.JAGGED_PEAKS.get())) {
            manager.spawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)CCBEntityTypes.GOAT.get(), 5, 1, 3));
        }
        if (manager.isIn(Biome.Category.EXTREME_HILLS)) {
            if (((Boolean)CavesAndCliffsConfig.GENERATE_GOATS.get()).booleanValue() && !manager.isMountainBiome()) {
                manager.spawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)CCBEntityTypes.GOAT.get(), ((Integer)CavesAndCliffsConfig.GOAT_SPAWN_WEIGHT.get()).intValue(), 4, 6));
            }
            VanillaBiomeFeatures.addEmeraldOre(manager.generation());
            VanillaBiomeFeatures.addInfestedStone(manager.generation());
        }
    }

    private static class GlobalBiomeManager {
        private final BiomeLoadingEvent event;

        public GlobalBiomeManager(BiomeLoadingEvent event) {
            this.event = event;
        }

        public Biome.Category getCategory() {
            return this.event.getCategory();
        }

        public ResourceLocation getName() {
            return this.event.getName();
        }

        public BiomeGenerationSettingsBuilder generation() {
            return this.event.getGeneration();
        }

        public MobSpawnInfoBuilder spawns() {
            return this.event.getSpawns();
        }

        public boolean isIn(RegistryKey<Biome> biomeIn) {
            RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)this.getName());
            return biomeIn == biome;
        }

        public boolean isIn(Biome biomeIn) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(this.getName());
            return biomeIn == biome;
        }

        public boolean isIn(Biome.Category category) {
            return this.getCategory() == category;
        }

        public boolean canGenerate() {
            return !this.isIn(Biome.Category.NETHER) && !this.isIn(Biome.Category.THEEND) && !this.isIn(Biome.Category.NONE);
        }

        public boolean isMountainBiome() {
            return this.isIn((Biome)CCBBiomes.MEADOW.get()) || this.isIn((Biome)CCBBiomes.GROVE.get()) || this.isIn((Biome)CCBBiomes.SNOWY_SLOPES.get()) || this.isIn((Biome)CCBBiomes.JAGGED_PEAKS.get()) || this.isIn((Biome)CCBBiomes.FROZEN_PEAKS.get()) || this.isIn((Biome)CCBBiomes.STONY_PEAKS.get());
        }
    }

    static class BiomeFeatures {
        BiomeFeatures() {
        }

        private static void generateCaveFeatures(GlobalBiomeManager manager) {
            BiomeFeatures.generateCaveFeatures(manager, false);
        }

        private static void generateCaveFeatures(GlobalBiomeManager manager, boolean isOcean) {
            VanillaBiomeFeatures.addCaveWaterMobs(manager.spawns());
            VanillaBiomeFeatures.addAmethystGeodes(manager.generation());
            VanillaBiomeFeatures.addMineables(manager.generation(), isOcean);
            VanillaBiomeFeatures.addCopperOre(manager.generation());
            VanillaBiomeFeatures.addDefaultOres(manager.generation());
        }

        private static void generateDripstoneFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addDripstoneCaveMobs(manager.spawns());
            VanillaBiomeFeatures.addMineables(manager.generation());
            VanillaBiomeFeatures.addCopperOre(manager.generation(), true);
            VanillaBiomeFeatures.addDripstone(manager.generation());
        }

        private static void generateLushCaveFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addMineables(manager.generation());
            VanillaBiomeFeatures.addCaveWaterMobs(manager.spawns());
            VanillaBiomeFeatures.addClayOre(manager.generation());
            VanillaBiomeFeatures.addLushCavesDecoration(manager.generation());
            if (!((Boolean)CavesAndCliffsConfig.LEGACY_AXOLOTL_GENERATION.get()).booleanValue()) {
                manager.spawns().func_242575_a(EntityHelper.AXOLOTLS, new MobSpawnInfo.Spawners((EntityType)CCBEntityTypes.AXOLOTL.get(), 10, 4, 6));
            }
            manager.spawns().func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_204262_at, 25, 8, 8));
        }
    }
}

