/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.math.floatprovider;

import com.blackgear.cavesandcliffs.common.math.floatprovider.FloatProvider;
import com.blackgear.cavesandcliffs.common.math.floatprovider.FloatProviderType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;

public class ConstantFloatProvider
extends FloatProvider {
    public static final ConstantFloatProvider ZERO = new ConstantFloatProvider(0.0f);
    public static final Codec<ConstantFloatProvider> CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("value").forGetter(provider -> Float.valueOf(provider.value))).apply((Applicative)instance, ConstantFloatProvider::new))).xmap(either -> (ConstantFloatProvider)either.map(ConstantFloatProvider::create, provider -> provider), provider -> Either.left((Object)Float.valueOf(provider.value)));
    private final float value;

    public static ConstantFloatProvider create(float value) {
        return value == 0.0f ? ZERO : new ConstantFloatProvider(value);
    }

    private ConstantFloatProvider(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public float get(Random rand) {
        return this.value;
    }

    @Override
    public float getMin() {
        return this.value;
    }

    @Override
    public float getMax() {
        return this.value;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.CONSTANT;
    }

    public String toString() {
        return Float.toString(this.value);
    }
}

