/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util;

import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBBiomes;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;

public class EntityHelper {
    public static final DamageSource FREEZE = new DamageSource("freeze").func_76348_h();
    public static final DamageSource FALLING_STALACTITE = EntityHelper.setFallingBlock(new DamageSource("fallingStalactite"));
    public static final DamageSource STALAGMITE = EntityHelper.setFallingBlock(new DamageSource("stalagmite"));
    public static final EntityClassification AXOLOTLS = EntityClassification.create((String)"axolotls", (String)"axolotls", (int)5, (boolean)true, (boolean)false, (int)128);
    public static final EntityClassification UNDERGROUND_WATER_CREATURE = EntityClassification.create((String)"underground_water_creature", (String)"underground_water_creature", (int)5, (boolean)true, (boolean)false, (int)128);
    public static final Pose LONG_JUMPING = Pose.SPIN_ATTACK;

    private static DamageSource setFallingBlock(DamageSource source) {
        source = DamageSource.field_82729_p;
        return source;
    }

    public static boolean canSpawnUnderground(EntityType<? extends LivingEntity> entityType, IServerWorld worldIn, SpawnReason spawnReason, BlockPos pos, Random random) {
        return pos.func_177956_o() < worldIn.func_181545_F() && pos.func_177956_o() < worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR, pos.func_177958_n(), pos.func_177952_p()) && EntityHelper.hasNoLight(worldIn, pos) && EntityHelper.hasStoneFloor(pos, worldIn);
    }

    public static boolean canTropicalFishSpawn(EntityType<? extends TropicalFishEntity> entityType, IServerWorld worldIn, SpawnReason spawnReason, BlockPos pos, Random random) {
        return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) && worldIn.func_226691_t_(pos) == CCBBiomes.LUSH_CAVES.get() || AbstractFishEntity.func_223363_b(entityType, (IWorld)worldIn, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random);
    }

    public static boolean hasStoneFloor(BlockPos pos, IServerWorld worldIn) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int i = 0; i < 5; ++i) {
            mutable.func_189536_c(Direction.DOWN);
            BlockState blockState = worldIn.func_180495_p((BlockPos)mutable);
            if (blockState.func_235714_a_((ITag)BlockTags.field_242172_aH)) {
                return true;
            }
            if (blockState.func_203425_a(Blocks.field_150355_j)) continue;
            return false;
        }
        return false;
    }

    public static boolean hasNoLight(IServerWorld worldIn, BlockPos pos) {
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i == 0;
    }
}

