/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util.feature;

import com.blackgear.cavesandcliffs.common.blocks.PointedDripstoneBlock;
import com.blackgear.cavesandcliffs.common.blocks.enums.Thickness;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.core.other.tags.CCBBlockTags;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class DripstoneHelper {
    public static double scaleHeightFromRadius(double radius, double scale, double heightScale, double bluntness) {
        if (radius < bluntness) {
            radius = bluntness;
        }
        double density = radius / scale * 0.384;
        double radiusX = 0.75 * Math.pow(density, 1.3);
        double radiusY = Math.pow(density, 0.7);
        double radiusZ = 0.3 * Math.log(density);
        double height = heightScale * (radiusX - radiusY - radiusZ);
        height = Math.max(height, 0.0);
        return height / 0.4 * scale;
    }

    public static boolean canGenerateBase(ISeedReader world, BlockPos pos, int height) {
        if (DripstoneHelper.canGenerateOrLava((IWorld)world, pos)) {
            return false;
        }
        float length = 6.0f / (float)height;
        for (float radius = 0.0f; radius < 6.3f; radius += length) {
            int radiusZ;
            int radiusX = (int)(MathHelper.func_76134_b((float)radius) * (float)height);
            if (!DripstoneHelper.canGenerateOrLava((IWorld)world, pos.func_177982_a(radiusX, 0, radiusZ = (int)(MathHelper.func_76126_a((float)radius) * (float)height)))) continue;
            return false;
        }
        return true;
    }

    public static boolean canGenerate(IWorld world, BlockPos pos) {
        return world.func_217375_a(pos, DripstoneHelper::canGenerate);
    }

    public static boolean canGenerateOrLava(IWorld world, BlockPos pos) {
        return world.func_217375_a(pos, DripstoneHelper::canGenerateOrLava);
    }

    protected static void getDripstoneThickness(Direction direction, int height, boolean merge, Consumer<BlockState> callback) {
        if (height >= 3) {
            callback.accept(DripstoneHelper.getState(direction, Thickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                callback.accept(DripstoneHelper.getState(direction, Thickness.MIDDLE));
            }
        }
        if (height >= 2) {
            callback.accept(DripstoneHelper.getState(direction, Thickness.FRUSTUM));
        }
        if (height >= 1) {
            callback.accept(DripstoneHelper.getState(direction, merge ? Thickness.TIP_MERGE : Thickness.TIP));
        }
    }

    public static void generatePointedDripstone(ISeedReader world, BlockPos pos, Direction direction, int height, boolean merge) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        DripstoneHelper.getDripstoneThickness(direction, height, merge, state -> {
            if (state.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get())) {
                state = (BlockState)state.func_206870_a((Property)PointedDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtils.isWater((IWorldReader)world, (BlockPos)mutable)));
            }
            world.func_180501_a((BlockPos)mutable, state, 2);
            mutable.func_189536_c(direction);
        });
    }

    public static boolean generateDripstoneBlock(ISeedReader world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_235714_a_(CCBBlockTags.DRIPSTONE_REPLACEABLE_BLOCKS)) {
            world.func_180501_a(pos, ((Block)CCBBlocks.DRIPSTONE_BLOCK.get()).func_176223_P(), 2);
            return true;
        }
        return false;
    }

    private static BlockState getState(Direction direction, Thickness thickness) {
        return (BlockState)((BlockState)((Block)CCBBlocks.POINTED_DRIPSTONE.get()).func_176223_P().func_206870_a((Property)PointedDripstoneBlock.VERTICAL_DIRECTION, (Comparable)direction)).func_206870_a(PointedDripstoneBlock.THICKNESS, (Comparable)((Object)thickness));
    }

    public static boolean canReplaceOrLava(BlockState state) {
        return DripstoneHelper.canReplace(state) || state.func_203425_a(Blocks.field_150353_l);
    }

    public static boolean canReplace(BlockState state) {
        return state.func_203425_a((Block)CCBBlocks.DRIPSTONE_BLOCK.get()) || state.func_235714_a_(CCBBlockTags.DRIPSTONE_REPLACEABLE_BLOCKS);
    }

    public static boolean canGenerate(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j);
    }

    public static boolean canGenerateOrLava(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j) || state.func_203425_a(Blocks.field_150353_l);
    }
}

