/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world;

import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.common.world.CCBConfiguredFeatures;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;

public class VanillaBiomeFeatures {
    public static void addMineables(BiomeGenerationSettingsBuilder builder) {
        VanillaBiomeFeatures.addMineables(builder, false);
    }

    public static void addMineables(BiomeGenerationSettingsBuilder builder, boolean isOcean) {
        if (!isOcean && ((Boolean)CavesAndCliffsConfig.GENERATE_GLOW_LICHEN.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.GLOW_LICHEN);
        }
        if (((Boolean)CavesAndCliffsConfig.GENERATE_TUFF.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, CCBConfiguredFeatures.ORE_TUFF);
        }
        if (((Boolean)CavesAndCliffsConfig.GENERATE_DEEPSLATE.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, CCBConfiguredFeatures.ORE_DEEPSLATE);
        }
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.RARE_DRIPSTONE_CLUSTER);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.RARE_SMALL_DRIPSTONE);
    }

    public static void addDripstone(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, CCBConfiguredFeatures.LARGE_DRIPSTONE);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.DRIPSTONE_CLUSTER);
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.SMALL_DRIPSTONE);
    }

    public static void addDefaultOres(BiomeGenerationSettingsBuilder builder) {
        if (((Boolean)CavesAndCliffsConfig.GENERATE_DEEPSLATE_ORES.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_COAL);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_IRON);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_GOLD);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_REDSTONE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_DIAMOND);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_LAPIS);
        }
    }

    public static void addCopperOre(BiomeGenerationSettingsBuilder builder) {
        VanillaBiomeFeatures.addCopperOre(builder, false);
    }

    public static void addCopperOre(BiomeGenerationSettingsBuilder builder, boolean largeCopperOre) {
        if (((Boolean)CavesAndCliffsConfig.GENERATE_COPPER_ORE.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, largeCopperOre && (Boolean)CavesAndCliffsConfig.DRIPSTONE_CAVE_LARGE_COPPER_BLOBS.get() != false ? CCBConfiguredFeatures.ORE_COPPER_LARGE : CCBConfiguredFeatures.ORE_COPPER);
        }
    }

    public static void addEmeraldOre(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_DEEPSLATE_EMERALD);
    }

    public static void addInfestedStone(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, CCBConfiguredFeatures.ORE_INFESTED);
    }

    public static void addLushCavesDecoration(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.LUSH_CAVES_CEILING_VEGETATION);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.CAVE_VINES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.LUSH_CAVES_CLAY);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.LUSH_CAVES_VEGETATION);
        if (((Boolean)CavesAndCliffsConfig.GENERATE_AZALEA_TREES.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.ROOTED_AZALEA_TREES);
        }
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.SPORE_BLOSSOM);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.CLASSIC_VINES_CAVE_FEATURE);
    }

    public static void addClayOre(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, CCBConfiguredFeatures.ORE_CLAY);
    }

    public static void addAmethystGeodes(BiomeGenerationSettingsBuilder builder) {
        if (((Boolean)CavesAndCliffsConfig.GENERATE_AMETHYST_GEODES.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, CCBConfiguredFeatures.AMETHYST_GEODE);
        }
    }

    public static void addCaveWaterMobs(MobSpawnInfoBuilder builder) {
        if (((Boolean)CavesAndCliffsConfig.GENERATE_GLOW_SQUIDS.get()).booleanValue()) {
            builder.func_242575_a(EntityHelper.UNDERGROUND_WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)CCBEntityTypes.GLOW_SQUID.get(), ((Integer)CavesAndCliffsConfig.GLOW_SQUID_SPAWN_WEIGHT.get()).intValue(), 4, 6));
        }
        if (((Boolean)CavesAndCliffsConfig.GENERATE_AXOLOTLS.get()).booleanValue() && ((Boolean)CavesAndCliffsConfig.LEGACY_AXOLOTL_GENERATION.get()).booleanValue()) {
            builder.func_242575_a(EntityHelper.AXOLOTLS, new MobSpawnInfo.Spawners((EntityType)CCBEntityTypes.AXOLOTL.get(), ((Integer)CavesAndCliffsConfig.AXOLOTL_SPAWN_WEIGHT.get()).intValue(), 4, 6));
        }
    }

    public static void addDripstoneCaveMobs(MobSpawnInfoBuilder builder) {
        DefaultBiomeFeatures.func_243734_b((MobSpawnInfo.Builder)builder);
        VanillaBiomeFeatures.addCaveWaterMobs(builder);
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_204724_o, 95, 4, 4));
        DefaultBiomeFeatures.func_243735_b((MobSpawnInfo.Builder)builder, (int)95, (int)5, (int)100);
    }

    public static void addMeadowFlowers(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243848_au);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.FLOWER_MEADOW);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CCBConfiguredFeatures.MEADOW_TREES);
    }
}

