/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.common.math.floatprovider.ClampedNormalFloatProvider;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.common.util.feature.CaveSurface;
import com.blackgear.cavesandcliffs.common.util.feature.DripstoneHelper;
import com.blackgear.cavesandcliffs.common.world.gen.feature.DripstoneClusterFeatureConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class DripstoneClusterFeature
extends Feature<DripstoneClusterFeatureConfig> {
    public DripstoneClusterFeature(Codec<DripstoneClusterFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, DripstoneClusterFeatureConfig config) {
        if (!DripstoneHelper.canGenerate((IWorld)reader, pos)) {
            return false;
        }
        int height = config.height.get(rand);
        float wetness = config.wetness.get(rand);
        float density = config.density.get(rand);
        int radiusX = config.radius.get(rand);
        int radiusZ = config.radius.get(rand);
        for (int localX = -radiusX; localX <= radiusX; ++localX) {
            for (int localZ = -radiusZ; localZ <= radiusZ; ++localZ) {
                double dripstoneChance = this.dripstoneChance(radiusX, radiusZ, localX, localZ, config);
                BlockPos blockPos = pos.func_177982_a(localX, 0, localZ);
                this.generate(reader, rand, blockPos, localX, localZ, wetness, dripstoneChance, height, density, config);
            }
        }
        return true;
    }

    private void generate(ISeedReader readerIn, Random random, BlockPos pos, int localX, int localZ, float wetness, double dripstoneChance, int height, float density, DripstoneClusterFeatureConfig config) {
        Optional<CaveSurface> surface = CaveSurface.create(readerIn, pos, config.floorToCeilingSearchRange, DripstoneHelper::canGenerate, DripstoneHelper::canReplaceOrLava);
        if (surface.isPresent()) {
            OptionalInt ceilingHeight = surface.get().getCeilingHeight();
            OptionalInt floorHeight = surface.get().getFloorHeight();
            if (ceilingHeight.isPresent() || floorHeight.isPresent()) {
                boolean shouldMerge;
                int fromFloor;
                int fromCeiling;
                boolean canGenerateStalagmite;
                int caveHeight;
                int dripstoneLength;
                boolean canGenerateStalactite;
                CaveSurface caveSurface;
                boolean canGeneratePool;
                boolean bl = canGeneratePool = random.nextFloat() < wetness;
                if (canGeneratePool && floorHeight.isPresent() && this.canWaterSpawn(readerIn, BlockUtils.withY(pos, floorHeight.getAsInt()))) {
                    int floorY = floorHeight.getAsInt();
                    caveSurface = surface.get().withFloor(OptionalInt.of(floorY - 1));
                    readerIn.func_180501_a(BlockUtils.withY(pos, floorY), Blocks.field_150355_j.func_176223_P(), 2);
                } else {
                    caveSurface = surface.get();
                }
                OptionalInt caveFloorHeight = caveSurface.getFloorHeight();
                boolean bl2 = canGenerateStalactite = random.nextDouble() < dripstoneChance;
                if (ceilingHeight.isPresent() && canGenerateStalactite && !this.isLava((IWorldReader)readerIn, BlockUtils.withY(pos, ceilingHeight.getAsInt()))) {
                    dripstoneLength = config.dripstoneBlockLayerThickness.get(random);
                    this.placeDripstoneBlocks(readerIn, BlockUtils.withY(pos, ceilingHeight.getAsInt()), dripstoneLength, Direction.UP);
                    int dripstoneHeight = caveFloorHeight.isPresent() ? Math.min(height, ceilingHeight.getAsInt() - caveFloorHeight.getAsInt()) : height;
                    caveHeight = this.getHeight(random, localX, localZ, density, dripstoneHeight, config);
                } else {
                    caveHeight = 0;
                }
                boolean bl3 = canGenerateStalagmite = random.nextDouble() < dripstoneChance;
                if (caveFloorHeight.isPresent() && canGenerateStalagmite && !this.isLava((IWorldReader)readerIn, BlockUtils.withY(pos, caveFloorHeight.getAsInt()))) {
                    fromCeiling = config.dripstoneBlockLayerThickness.get(random);
                    this.placeDripstoneBlocks(readerIn, BlockUtils.withY(pos, caveFloorHeight.getAsInt()), fromCeiling, Direction.DOWN);
                    dripstoneLength = Math.max(0, caveHeight + MathUtils.nextBetween(random, -config.maxStalagmiteStalactiteHeightDiff, config.maxStalagmiteStalactiteHeightDiff));
                } else {
                    dripstoneLength = 0;
                }
                if (ceilingHeight.isPresent() && caveFloorHeight.isPresent() && ceilingHeight.getAsInt() - caveHeight <= caveFloorHeight.getAsInt() + dripstoneLength) {
                    int floorY = caveFloorHeight.getAsInt();
                    int ceilingY = ceilingHeight.getAsInt();
                    int minDistance = Math.max(ceilingY - caveHeight, floorY + 1);
                    int maxDistance = Math.min(floorY + dripstoneLength, ceilingY - 1);
                    int distance = MathUtils.nextBetween(random, minDistance, maxDistance + 1);
                    int validHeight = distance - 1;
                    fromCeiling = ceilingY - distance;
                    fromFloor = validHeight - floorY;
                } else {
                    fromCeiling = caveHeight;
                    fromFloor = dripstoneLength;
                }
                boolean bl4 = shouldMerge = random.nextBoolean() && fromCeiling > 0 && fromFloor > 0 && caveSurface.getOptionalHeight().isPresent() && fromCeiling + fromFloor == caveSurface.getOptionalHeight().getAsInt();
                if (ceilingHeight.isPresent()) {
                    DripstoneHelper.generatePointedDripstone(readerIn, BlockUtils.withY(pos, ceilingHeight.getAsInt() - 1), Direction.DOWN, fromCeiling, shouldMerge);
                }
                if (caveFloorHeight.isPresent()) {
                    DripstoneHelper.generatePointedDripstone(readerIn, BlockUtils.withY(pos, caveFloorHeight.getAsInt() + 1), Direction.UP, fromFloor, shouldMerge);
                }
            }
        }
    }

    private boolean isLava(IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos).func_203425_a(Blocks.field_150353_l);
    }

    private int getHeight(Random random, int localX, int localZ, float density, int height, DripstoneClusterFeatureConfig config) {
        if (random.nextFloat() > density) {
            return 0;
        }
        int lerp = Math.abs(localX) + Math.abs(localZ);
        float mean = (float)MathUtils.clampedLerpFromProgress(lerp, 0.0, config.maxDistanceFromCenterAffectingHeightBias, (double)height / 2.0, 0.0);
        return (int)DripstoneClusterFeature.clampedGaussian(random, 0.0f, height, mean, config.heightDeviation);
    }

    private boolean canWaterSpawn(ISeedReader readerIn, BlockPos pos) {
        BlockState blockState = readerIn.func_180495_p(pos);
        if (!(blockState.func_203425_a(Blocks.field_150355_j) || blockState.func_203425_a((Block)CCBBlocks.DRIPSTONE_BLOCK.get()) || blockState.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()))) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.isStoneOrWater((IWorld)readerIn, pos.func_177972_a(direction))) continue;
                return false;
            }
            return this.isStoneOrWater((IWorld)readerIn, pos.func_177977_b());
        }
        return false;
    }

    private boolean isStoneOrWater(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        return state.func_235714_a_((ITag)BlockTags.field_242172_aH) || state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private void placeDripstoneBlocks(ISeedReader readerIn, BlockPos pos, int height, Direction direction) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int i = 0; i < height; ++i) {
            if (!DripstoneHelper.generateDripstoneBlock(readerIn, (BlockPos)mutable)) {
                return;
            }
            mutable.func_189536_c(direction);
        }
    }

    private double dripstoneChance(int radiusX, int radiusZ, int localX, int localZ, DripstoneClusterFeatureConfig config) {
        int x = radiusX - Math.abs(localX);
        int z = radiusZ - Math.abs(localZ);
        int lerp = Math.min(x, z);
        return MathUtils.clampedLerpFromProgress(lerp, 0.0, config.maxDistanceFromCenterAffectingChanceOfDripstoneColumn, config.chanceOfDripstoneColumnAtMaxDistanceFromCenter, 1.0);
    }

    private static float clampedGaussian(Random random, float min, float max, float mean, float deviation) {
        return ClampedNormalFloatProvider.get(random, mean, deviation, min, max);
    }
}

