/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.worldgen;

import com.blackgear.cavesandcliffs.core.CavesAndCliffs;
import com.blackgear.cavesandcliffs.core.api.Registries;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBSurfaceBuilders;
import java.util.Objects;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCBBiomes {
    public static final Registries HELPER = CavesAndCliffs.REGISTRIES;
    public static final RegistryObject<Biome> LUSH_CAVES = HELPER.registerBiome("lush_caves", CCBBiomes::makeLushCaves);
    public static final RegistryObject<Biome> DRIPSTONE_CAVES = HELPER.registerBiome("dripstone_caves", CCBBiomes::makeDripstoneCaves);
    public static final RegistryObject<Biome> MEADOW = HELPER.registerBiome("meadow", CCBBiomes::makeMeadow);
    public static final RegistryObject<Biome> GROVE = HELPER.registerBiome("grove", CCBBiomes::makeGrove);
    public static final RegistryObject<Biome> SNOWY_SLOPES = HELPER.registerBiome("snowy_slopes", CCBBiomes::makeSnowySlopes);
    public static final RegistryObject<Biome> FROZEN_PEAKS = HELPER.registerBiome("frozen_peaks", CCBBiomes::makeFrozenPeaks);
    public static final RegistryObject<Biome> JAGGED_PEAKS = HELPER.registerBiome("jagged_peaks", CCBBiomes::makeJaggedPeaks);
    public static final RegistryObject<Biome> STONY_PEAKS = HELPER.registerBiome("stony_peaks", CCBBiomes::makeStonyPeaks);

    public static Biome makeLushCaves() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.5f).func_205417_d(0.5f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.5f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_LUSH_CAVES.get()))).func_235238_a_()).func_242458_a(spawnSettings.func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeDripstoneCaves() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244188_t);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.PLAINS).func_205421_a(0.125f).func_205420_b(0.05f).func_205414_c(0.8f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.8f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_DRIPSTONE_CAVES.get()))).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawnSettings.func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeMeadow() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200798_l, 1, 1, 2));
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 2, 2, 6));
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 2, 2, 4));
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.func_242516_a(StructureFeatures.field_244132_C);
        generationSettings.func_242516_a(StructureFeatures.field_244154_t);
        generationSettings.func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243711_Y((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.0f).func_205420_b(0.05f).func_205414_c(0.5f).func_205417_d(0.8f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(937679).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_MEADOW.get()))).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeGrove() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawnSettings);
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 8, 4, 4));
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 8, 2, 4));
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(CCBSurfaceBuilders.Configured.GROVE);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.func_242516_a(StructureFeatures.field_244159_y);
        generationSettings.func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243762_v((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.FOREST).func_205421_a(2.0f).func_205420_b(0.375f).func_205414_c(-0.2f).func_205417_d(0.8f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_GROVE.get()))).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeSnowySlopes() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(CCBSurfaceBuilders.Configured.SNOWY_SLOPES);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.func_242516_a(StructureFeatures.field_244132_C);
        generationSettings.func_242516_a(StructureFeatures.field_244135_a);
        generationSettings.func_242516_a(StructureFeatures.field_244141_g);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(2.0f).func_205420_b(0.375f).func_205414_c(-0.3f).func_205417_d(0.9f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_SNOWY_SLOPES.get()))).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeFrozenPeaks() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(CCBSurfaceBuilders.Configured.SNOWCAPPED_PEAKS);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.func_242516_a(StructureFeatures.field_244132_C);
        generationSettings.func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(3.0f).func_205420_b(0.375f).func_205414_c(-0.7f).func_205417_d(0.9f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_FROZEN_PEAKS.get()))).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeJaggedPeaks() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3));
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(CCBSurfaceBuilders.Configured.LOFTY_PEAKS);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.func_242516_a(StructureFeatures.field_244132_C);
        generationSettings.func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(3.0f).func_205420_b(0.375f).func_205414_c(-0.7f).func_205417_d(0.9f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.7f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_JAGGED_PEAKS.get()))).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeStonyPeaks() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(CCBSurfaceBuilders.Configured.STONY_PEAKS);
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.func_242516_a(StructureFeatures.field_244132_C);
        generationSettings.func_242516_a(StructureFeatures.field_244135_a);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(3.0f).func_205420_b(0.375f).func_205414_c(1.0f).func_205417_d(0.3f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.2f)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)((SoundEvent)CCBSoundEvents.MUSIC_OVERWORLD_STONY_PEAKS.get()))).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(new MobSpawnInfo.Builder().func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float modifier = temperature / 3.0f;
        modifier = MathHelper.func_76131_a((float)modifier, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - modifier * 0.05f), (float)(0.5f + modifier * 0.1f), (float)1.0f);
    }

    public static class Keys {
        public static final RegistryKey<Biome> LUSH_CAVES = Keys.getKey((Biome)LUSH_CAVES.get());
        public static final RegistryKey<Biome> DRIPSTONE_CAVES = Keys.getKey((Biome)DRIPSTONE_CAVES.get());
        public static final RegistryKey<Biome> MEADOW = Keys.getKey((Biome)MEADOW.get());
        public static final RegistryKey<Biome> GROVE = Keys.getKey((Biome)GROVE.get());
        public static final RegistryKey<Biome> SNOWY_SLOPES = Keys.getKey((Biome)SNOWY_SLOPES.get());
        public static final RegistryKey<Biome> FROZEN_PEAKS = Keys.getKey((Biome)FROZEN_PEAKS.get());
        public static final RegistryKey<Biome> JAGGED_PEAKS = Keys.getKey((Biome)JAGGED_PEAKS.get());
        public static final RegistryKey<Biome> STONY_PEAKS = Keys.getKey((Biome)STONY_PEAKS.get());

        private static RegistryKey<Biome> getKey(Biome biome) {
            return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(biome.getRegistryName()));
        }
    }
}

