/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.common.block;

import com.blackgear.cavesandcliffs.common.blocks.ICauldron;
import com.blackgear.cavesandcliffs.common.blocks.PointedDripstoneBlock;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CauldronBlock.class})
public class CauldronBlockMixin
extends Block
implements ICauldron {
    @Shadow
    @Final
    public static IntegerProperty field_176591_a;

    public CauldronBlockMixin(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    @Override
    public boolean isFull(BlockState state) {
        return (Integer)state.func_177229_b((Property)field_176591_a) == 3;
    }

    @Override
    public double getFluidHeight(BlockState state) {
        return (6.0 + (double)((Integer)state.func_177229_b((Property)field_176591_a)).intValue() * 3.0) / 16.0;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        Fluid fluid;
        BlockPos dripPos = PointedDripstoneBlock.getDripPos((World)worldIn, pos);
        if (dripPos != null && (fluid = PointedDripstoneBlock.getDripFluid((World)worldIn, dripPos)) != Fluids.field_204541_a && this.canBeFilledByDripstone(fluid)) {
            this.fillFromDripstone(state, (World)worldIn, pos, fluid);
        }
    }

    @Override
    public boolean canBeFilledByDripstone(Fluid fluid) {
        return true;
    }

    @Override
    public void fillFromDripstone(BlockState state, World world, BlockPos pos, Fluid fluid) {
        if (fluid == Fluids.field_204546_a) {
            BlockState blockState = world.func_180495_p(pos);
            if ((Integer)blockState.func_177229_b((Property)field_176591_a) < 3) {
                world.func_180501_a(pos, (BlockState)blockState.func_235896_a_((Property)field_176591_a), 2);
                world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON.get(), SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        } else if (fluid == Fluids.field_204547_b) {
            world.func_175656_a(pos, ((Block)CCBBlocks.LAVA_CAULDRON.get()).func_176223_P());
            world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON.get(), SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }
}

