/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.common.entity;

import com.blackgear.cavesandcliffs.common.blocks.IOxidizable;
import com.blackgear.cavesandcliffs.common.blocks.LightningRodBlock;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.common.util.WorldEvents;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBoltEntity.class})
public abstract class LightningBoltEntityMixin
extends Entity {
    @Shadow
    private int field_70262_b;

    public LightningBoltEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    private void powerLightningRod() {
        BlockPos affectedBlockPos = this.getAffectedBlockPos();
        BlockState affectedBlockState = this.field_70170_p.func_180495_p(affectedBlockPos);
        if (affectedBlockState.func_203425_a((Block)CCBBlocks.LIGHTNING_ROD.get())) {
            ((LightningRodBlock)affectedBlockState.func_177230_c()).setPowered(affectedBlockState, this.field_70170_p, affectedBlockPos);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void worldTick(CallbackInfo info) {
        if (this.field_70262_b == 2 && !this.field_70170_p.func_201670_d()) {
            this.powerLightningRod();
            this.cleanOxidization(this.field_70170_p, this.getAffectedBlockPos());
        }
    }

    private BlockPos getAffectedBlockPos() {
        Vector3d pos = this.func_213303_ch();
        return new BlockPos(pos.field_72450_a, pos.field_72448_b - 1.0E-6, pos.field_72449_c);
    }

    private void cleanOxidization(World world, BlockPos pos) {
        BlockState state;
        BlockPos blockPos;
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_203425_a((Block)CCBBlocks.LIGHTNING_ROD.get())) {
            blockPos = pos.func_177972_a(((Direction)blockState.func_177229_b((Property)LightningRodBlock.field_176387_N)).func_176734_d());
            state = world.func_180495_p(blockPos);
        } else {
            blockPos = pos;
            state = blockState;
        }
        if (state.func_177230_c() instanceof IOxidizable) {
            world.func_175656_a(blockPos, IOxidizable.getUnaffectedOxidationState(world.func_180495_p(blockPos)));
            BlockPos.Mutable mutable = pos.func_239590_i_();
            int maxCleanRadius = world.field_73012_v.nextInt(3) + 3;
            for (int radius = 0; radius < maxCleanRadius; ++radius) {
                int count = world.field_73012_v.nextInt(8) + 1;
                this.cleanOxidizationAround(world, blockPos, mutable, count);
            }
        }
    }

    private void cleanOxidizationAround(World world, BlockPos pos, BlockPos.Mutable mutable, int count) {
        Optional<BlockPos> blockPos;
        mutable.func_189533_g((Vector3i)pos);
        for (int i = 0; i < count && (blockPos = this.cleanOxidizationAround(world, (BlockPos)mutable)).isPresent(); ++i) {
            mutable.func_189533_g((Vector3i)blockPos.get());
        }
    }

    private Optional<BlockPos> cleanOxidizationAround(World world, BlockPos pos) {
        for (BlockPos positions : BlockUtils.iterateRandomly(world.field_73012_v, 10, pos, 1)) {
            BlockState state = world.func_180495_p(positions);
            if (!(state.func_177230_c() instanceof IOxidizable)) continue;
            IOxidizable.getDecreasedOxidationState(state).ifPresent(stateIn -> world.func_175656_a(positions, stateIn));
            WorldEvents.syncWorldEvent(world, 3002, positions, -1);
            return Optional.of(positions);
        }
        return Optional.empty();
    }
}

