/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.loader;

import com.sighs.petiteinventory.loader.Entry;
import com.sighs.petiteinventory.loader.EntryLoader;
import com.sighs.petiteinventory.utils.ItemUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class EntryCache {
    public static final HashMap<String, String> UnitMapCache = new HashMap();
    public static final HashMap<String, String> TagMapCache = new HashMap();

    public static void putEntry(Entry rule) {
        String result = rule.getResult();
        for (String match : rule.getMatch()) {
            if (match.startsWith("#")) {
                TagMapCache.put(match.replace("#", ""), result);
                continue;
            }
            UnitMapCache.put(match, result);
        }
    }

    public static void clearCache() {
        UnitMapCache.clear();
        TagMapCache.clear();
    }

    public static void loadAllRule() {
        EntryCache.clearCache();
        EntryLoader.loadAll().forEach(EntryCache::putEntry);
    }

    public static String matchItem(String id) {
        List<ResourceLocation> tags = ItemUtils.getItemTags(ItemUtils.getItemById(id));
        if (tags.isEmpty()) {
            return UnitMapCache.getOrDefault(id, null);
        }
        for (ResourceLocation tag : tags) {
            String item = EntryCache.matchTag(tag);
            if (item == null) continue;
            return item;
        }
        return UnitMapCache.getOrDefault(id, null);
    }

    public static String matchTag(String tagId) {
        return TagMapCache.getOrDefault(tagId, null);
    }

    public static String matchTag(ResourceLocation tagId) {
        return tagId != null ? EntryCache.matchTag(tagId.toString()) : null;
    }
}

