/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.mixin;

import com.sighs.petiteinventory.api.IAbstractContainerMenu;
import com.sighs.petiteinventory.init.Area;
import com.sighs.petiteinventory.init.ContainerGrid;
import com.sighs.petiteinventory.utils.SlotUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin
implements IAbstractContainerMenu {
    @Shadow
    @Final
    public NonNullList<Slot> f_38839_;
    @Unique
    private Player player;

    @Shadow
    protected abstract boolean m_38903_(ItemStack var1, int var2, int var3, boolean var4);

    @Override
    public void setPlayer(Player player) {
        this.player = player;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Inject(method={"clicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void qq(int slot, int p_150401_, ClickType type, Player p_150403_, CallbackInfo ci) {
        ContainerGrid.Cell targetCell;
        ContainerGrid targetGrid;
        if (slot < 0 || slot > this.f_38839_.size()) {
            return;
        }
        if (type != ClickType.QUICK_MOVE) {
            return;
        }
        if (this instanceof CreativeModeInventoryScreen.ItemPickerMenu) {
            return;
        }
        Slot clickedSlot = (Slot)this.f_38839_.get(slot);
        ArrayList<Slot> targetContainerSlots = new ArrayList<Slot>();
        if (clickedSlot.f_40218_ instanceof Inventory) {
            this.f_38839_.forEach(s -> {
                if (!(s.f_40218_ instanceof Inventory)) {
                    targetContainerSlots.add((Slot)s);
                }
            });
            targetGrid = ContainerGrid.parse(targetContainerSlots);
        } else {
            if (SlotUtils.hasEmptyHotbarSlot(this.player)) {
                return;
            }
            this.f_38839_.forEach(s -> {
                if (s.f_40218_ instanceof Inventory) {
                    targetContainerSlots.add((Slot)s);
                }
            });
            targetGrid = ContainerGrid.parse(targetContainerSlots);
            targetGrid.removeRow(targetGrid.getHeight() - 1);
        }
        ItemStack clickedItem = clickedSlot.m_7993_();
        int start = ((Slot)targetContainerSlots.get((int)0)).f_40219_;
        int end = ((Slot)targetContainerSlots.get((int)(targetContainerSlots.size() - 1))).f_40219_;
        if (clickedItem.m_41753_()) {
            this.tryMoveStackableItem(clickedItem, start, end, false);
        }
        if (!clickedItem.m_41619_() && (targetCell = targetGrid.findArea(Area.of(clickedItem))) != null) {
            int index = targetCell.slot().f_40219_;
            this.m_38903_(clickedItem, index, index + 1, false);
        }
        ci.cancel();
    }

    private boolean tryMoveStackableItem(ItemStack stackToMove, int startIndex, int endIndex, boolean reverse) {
        int currentIndex;
        boolean moved = false;
        int n = currentIndex = reverse ? endIndex - 1 : startIndex;
        while (!stackToMove.m_41619_() && !(!reverse ? currentIndex >= endIndex : currentIndex < startIndex)) {
            Slot slot = (Slot)this.f_38839_.get(currentIndex);
            ItemStack slotItem = slot.m_7993_();
            if (!slotItem.m_41619_() && ItemStack.m_150942_((ItemStack)stackToMove, (ItemStack)slotItem)) {
                moved = this.tryStackItems(stackToMove, slotItem, slot) || moved;
            }
            currentIndex = reverse ? currentIndex - 1 : currentIndex + 1;
        }
        return moved;
    }

    private boolean tryStackItems(ItemStack sourceStack, ItemStack targetStack, Slot slot) {
        int maxStackSize;
        int totalCount = targetStack.m_41613_() + sourceStack.m_41613_();
        if (totalCount <= (maxStackSize = Math.min(slot.m_6641_(), sourceStack.m_41741_()))) {
            sourceStack.m_41764_(0);
            targetStack.m_41764_(totalCount);
            slot.m_6654_();
            return true;
        }
        if (targetStack.m_41613_() < maxStackSize) {
            int amountToTransfer = maxStackSize - targetStack.m_41613_();
            sourceStack.m_41774_(amountToTransfer);
            targetStack.m_41764_(maxStackSize);
            slot.m_6654_();
            return true;
        }
        return false;
    }
}

