/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.utils;

import com.sighs.petiteinventory.init.ContainerGrid;
import com.sighs.petiteinventory.utils.SlotUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="petiteinventory")
public class ClientUtils {
    private static ContainerGrid clientGrid = null;

    public static ContainerGrid getContainerGrid() {
        if (clientGrid == null) {
            clientGrid = ClientUtils.getClientContainerGrid();
        }
        return clientGrid;
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.phase == TickEvent.Phase.END && player != null) {
            clientGrid = ClientUtils.getClientContainerGrid();
        }
    }

    private static ContainerGrid getClientContainerGrid() {
        AbstractContainerMenu menu = Minecraft.m_91087_().f_91074_.f_36096_;
        return SlotUtils.getContainerGrid(menu);
    }

    public static Slot getMappedSlot(Slot originCell) {
        ContainerGrid grid = ClientUtils.getContainerGrid();
        ContainerGrid.Cell hoverCell = grid.getCell(originCell);
        ContainerGrid.Cell targetCell = grid.getCellMap().get(hoverCell);
        return targetCell != null ? targetCell.slot() : originCell;
    }

    public static boolean isClientGridSlot(Slot slot) {
        if (Minecraft.m_91087_().f_91080_ instanceof CreativeModeInventoryScreen) {
            return false;
        }
        if (slot == null) {
            return false;
        }
        return ClientUtils.getContainerGrid().getCell(slot) != null;
    }
}

