/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.utils;

import com.sighs.petiteinventory.Config;
import com.sighs.petiteinventory.init.Area;
import com.sighs.petiteinventory.init.ContainerGrid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SlotUtils {
    public static void findIncludesArea() {
    }

    public static void mappedCellTransform() {
    }

    public static boolean isSlotValid(Slot slot) {
        return slot != null && slot.f_40218_ instanceof Inventory;
    }

    public static ContainerGrid getContainerGrid(AbstractContainerMenu menu) {
        ArrayList<Slot> girdSlot = new ArrayList<Slot>();
        String menuType = menu.getClass().toString();
        boolean matchedMenu = ((List)Config.WHITELIST.get()).contains(menuType);
        boolean enableInventory = (Boolean)Config.ENABLE_INVENTORY.get();
        if (menu instanceof InventoryMenu) {
            for (int i = 9; i < 36; ++i) {
                if (!enableInventory) continue;
                girdSlot.add(menu.m_38853_(i));
            }
        } else {
            for (Slot slot : menu.f_38839_) {
                if ((!matchedMenu || slot.f_40218_ instanceof Inventory) && (!enableInventory || !(slot.f_40218_ instanceof Inventory))) continue;
                girdSlot.add(slot);
            }
        }
        ContainerGrid grid = ContainerGrid.parse(girdSlot);
        if (enableInventory && !(menu instanceof InventoryMenu)) {
            grid.removeRow(grid.getHeight() - 1);
        }
        return grid;
    }

    public static int findSlotIndexForArea(Player player, Area area) {
        Inventory playerInventory = player.m_150109_();
        List<Slot> slots = SlotUtils.createInventorySlots(playerInventory);
        ContainerGrid grid = ContainerGrid.parse(slots);
        ContainerGrid.Cell foundCell = grid.findEmptyArea(area);
        if (foundCell != null) {
            return SlotUtils.convertCellToSlotIndex(foundCell);
        }
        return -1;
    }

    private static List<Slot> createInventorySlots(Inventory inventory) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int baseY = 84;
        int baseX = 8;
        int slotSpacing = 18;
        int slotIndex = 9;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = baseX + col * slotSpacing;
                int y = baseY + row * slotSpacing;
                InventorySlot slot = new InventorySlot((Container)inventory, slotIndex, x, y);
                slots.add(slot);
                ++slotIndex;
            }
        }
        return slots;
    }

    private static int convertCellToSlotIndex(ContainerGrid.Cell cell) {
        return 9 + cell.x() + cell.y() * 9;
    }

    public static boolean hasEmptyHotbarSlot(Player player) {
        Inventory inventory = player.m_150109_();
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack itemStack = inventory.m_8020_(slot);
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private static class InventorySlot
    extends Slot {
        public InventorySlot(Container container, int slotIndex, int x, int y) {
            super(container, slotIndex, x, y);
        }
    }
}

