/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.petiteinventory.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class Utils {
    public static String getItemRegistryName(Item item) {
        if (item == null) {
            return null;
        }
        ResourceLocation registryName = null;
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            if (!((Item)entry.getValue()).equals(item)) continue;
            registryName = ((ResourceKey)entry.getKey()).m_135782_();
        }
        if (registryName == null) {
            return null;
        }
        return registryName.toString();
    }

    public static Item getItemById(String registryName) {
        if (registryName == null || registryName.isEmpty()) {
            return null;
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(registryName);
            if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
                return null;
            }
            Item item = null;
            for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
                if (!((ResourceKey)entry.getKey()).m_135782_().equals((Object)resourceLocation)) continue;
                item = (Item)entry.getValue();
            }
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<ResourceLocation> getItemTags(Item item) {
        ITagManager tagManager = ForgeRegistries.ITEMS.tags();
        if (tagManager == null) {
            return Collections.emptyList();
        }
        return tagManager.getReverseTag((Object)item).map(reverseTag -> reverseTag.getTagKeys().map(TagKey::f_203868_).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static boolean isItemIdEmpty(String id) {
        return id == null || id.equals("minecraft:air");
    }
}

