/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CenserBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final MapCodec<CenserBlock> CODEC = CenserBlock.simpleCodec(CenserBlock::new);

    public CenserBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3 vec3 = pState.getOffset(pLevel, pPos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof CenserBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CenserBlockEntity censer = (CenserBlockEntity)be;
        if (heldItem.getItem() instanceof FlintAndSteelItem && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            ItemStack herb1 = censer.getItem(0);
            ItemStack herb2 = censer.getItem(1);
            if (herb1.isEmpty() || herb2.isEmpty()) {
                if (level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.hexalia.censer_not_full"), true);
                }
                return ItemInteractionResult.FAIL;
            }
            HerbCombination combo = new HerbCombination(herb1.getItem(), herb2.getItem());
            if (!CenserEffectHandler.isValidCombination(herb1.getItem(), herb2.getItem())) {
                if (level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.hexalia.invalid_herb_combination"), true);
                }
                return ItemInteractionResult.FAIL;
            }
            if (level.isClientSide()) {
                censer.clearItems();
            } else {
                censer.clearItems();
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                censer.setActiveCombination(combo);
                censer.setBurnTime((Integer)Configuration.CENSER_EFFECT_DURATION.get());
                this.sendEffectActivationMessage(level, pos, combo, player);
                CenserEffectHandler.startEffect(level, pos, combo);
            }
            heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.getItem() instanceof ShovelItem && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (level.isClientSide()) {
                censer.clearItems();
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                censer.setBurnTime(0);
                censer.clearItems();
                censer.setActiveCombination(null);
                level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (heldItem.isEmpty()) {
                for (int i = 0; i < censer.getItems().size(); ++i) {
                    ItemStack stackInSlot = censer.getItem(i);
                    if (stackInSlot.isEmpty()) continue;
                    ItemStack removed = censer.removeStack(i);
                    if (!player.getInventory().add(removed)) {
                        player.drop(removed, false);
                    }
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.5f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (heldItem.is(ModTags.Items.HERBS)) {
                for (int i = 0; i < censer.getItems().size(); ++i) {
                    if (!censer.getItem(i).isEmpty()) continue;
                    ItemStack toInsert = heldItem.copy();
                    toInsert.setCount(1);
                    censer.setItem(i, toInsert);
                    if (!player.isCreative()) {
                        heldItem.shrink(1);
                    }
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.5f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                if (level.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.hexalia.invalid_item"), true);
                }
                return ItemInteractionResult.FAIL;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void sendEffectActivationMessage(Level level, BlockPos pos, HerbCombination combo, Player activatingPlayer) {
        String key = CenserEffectHandler.getMessageKeyForCombination(combo);
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).inflate((double)radius);
        for (Player p : level.getEntitiesOfClass(Player.class, area)) {
            if (p.getUUID().equals(activatingPlayer.getUUID()) || !(p instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)p;
            sp.displayClientMessage((Component)Component.translatable((String)key), true);
        }
        if (!level.isClientSide() && activatingPlayer instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)activatingPlayer;
            sp.displayClientMessage((Component)Component.translatable((String)key), true);
        }
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            if (pRandom.nextInt(10) == 0) {
                pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + pRandom.nextFloat(), pRandom.nextFloat() * 0.7f + 0.6f, false);
            }
            pLevel.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, (double)pPos.getX() + 0.5 + pRandom.nextDouble() / 3.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + pRandom.nextDouble() + pRandom.nextDouble(), (double)pPos.getZ() + 0.5 + pRandom.nextDouble() / 3.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + 0.5 + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), (double)pPos.getY() + 0.4, (double)pPos.getZ() + 0.5 + pRandom.nextDouble() / 4.0 * (double)(pRandom.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
            if (pRandom.nextInt(25) == 0) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.3, (double)pPos.getZ() + 0.5, (double)(pRandom.nextFloat() / 8.0f), 0.0, (double)(pRandom.nextFloat() / 8.0f));
            }
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof CenserBlockEntity) {
                CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
                if (world instanceof ServerLevel) {
                    Containers.dropContents((Level)world, (BlockPos)pos, censer.getItems());
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, LIT});
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CenserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return CenserBlock.createTickerHelper(blockEntityType, ModBlockEntityTypes.CENSER.get(), (level1, pos, state1, blockEntity) -> blockEntity.tick(level1, pos, state1));
    }
}

