/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.EnchantedPlantBlock;
import net.astralya.hexalia.block.entity.custom.GrimshadeBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GrimshadeBlock
extends EnchantedPlantBlock
implements EntityBlock {
    public GrimshadeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        GrimshadeBlockEntity grim;
        BlockEntity be;
        if (player.getItemInHand(hand).getItem() != ModItems.HEX_FOCUS.get()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof GrimshadeBlockEntity && !(grim = (GrimshadeBlockEntity)be).isActive()) {
            this.playActivationEffects((ServerLevel)level, pos);
            this.doOneShotConversions((ServerLevel)level, pos);
            grim.activate();
        }
        return ItemInteractionResult.SUCCESS;
    }

    private void playActivationEffects(ServerLevel level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.WITHER_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.7, (double)pos.getZ() + 0.5, 24, 0.35, 0.35, 0.35, 0.02);
        level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 16, 0.35, 0.35, 0.35, 0.01);
    }

    private void doOneShotConversions(ServerLevel level, BlockPos pos) {
        AABB area = new AABB(pos).inflate(2.5);
        for (Object e : level.getEntitiesOfClass(Skeleton.class, area)) {
            WitherSkeleton wither = (WitherSkeleton)EntityType.WITHER_SKELETON.create((Level)level);
            wither.moveTo(e.getX(), e.getY(), e.getZ(), e.getYRot(), e.getXRot());
            e.discard();
            level.addFreshEntity((Entity)wither);
        }
        int[] skulls = new int[]{0};
        for (ItemEntity it : level.getEntitiesOfClass(ItemEntity.class, area, ent -> ent.getItem().is(Items.SKELETON_SKULL) && skulls[0] < 3)) {
            it.setItem(new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, it.getItem().getCount()));
            skulls[0] = skulls[0] + 1;
        }
        int minX = (int)Math.floor(area.minX);
        int minY = (int)Math.floor(area.minY);
        int minZ = (int)Math.floor(area.minZ);
        int maxX = (int)Math.floor(area.maxX);
        int maxY = (int)Math.floor(area.maxY);
        int maxZ = (int)Math.floor(area.maxZ);
        for (BlockPos p : BlockPos.betweenClosed((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockState t;
            if (skulls[0] >= 3) break;
            BlockState s = level.getBlockState(p);
            if (s.is(Blocks.SKELETON_SKULL)) {
                t = GrimshadeBlock.copyCommonProperties(s, Blocks.WITHER_SKELETON_SKULL.defaultBlockState());
                level.setBlock(p, t, 3);
                skulls[0] = skulls[0] + 1;
                continue;
            }
            if (s.is(Blocks.SKELETON_WALL_SKULL)) {
                t = Blocks.WITHER_SKELETON_WALL_SKULL.defaultBlockState();
                t = GrimshadeBlock.copyCommonProperties(s, t);
                if (s.hasProperty((Property)WallSkullBlock.FACING) && t.hasProperty((Property)WallSkullBlock.FACING)) {
                    t = (BlockState)t.setValue((Property)WallSkullBlock.FACING, (Comparable)((Direction)s.getValue((Property)WallSkullBlock.FACING)));
                }
                level.setBlock(p, t, 3);
                skulls[0] = skulls[0] + 1;
                continue;
            }
            if (!s.is((Block)ModBlocks.CANDLE_SKULL.get())) continue;
            t = GrimshadeBlock.copyCommonProperties(s, ((Block)ModBlocks.WITHER_CANDLE_SKULL.get()).defaultBlockState());
            level.setBlock(p, t, 3);
            skulls[0] = skulls[0] + 1;
        }
    }

    private static BlockState copyCommonProperties(BlockState from, BlockState to) {
        for (Property prop : from.getProperties()) {
            if (!to.hasProperty(prop)) continue;
            to = (BlockState)to.setValue(prop, from.getValue(prop));
        }
        return to;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return super.mayPlaceOn(state, level, pos) || state.is(Blocks.NETHERRACK) || state.is(Blocks.SOUL_SAND) || state.is(Blocks.SOUL_SOIL);
    }

    protected FluidState getFluidState(BlockState state) {
        return Fluids.EMPTY.defaultFluidState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return super.getStateForPlacement(ctx);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GrimshadeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, p, s, be) -> {
            if (be instanceof GrimshadeBlockEntity) {
                GrimshadeBlockEntity g = (GrimshadeBlockEntity)be;
                GrimshadeBlockEntity.tick(lvl, p, s, g);
            }
        };
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        GrimshadeBlockEntity g;
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof LivingEntity) || entity instanceof Player) {
            return;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof GrimshadeBlockEntity && (g = (GrimshadeBlockEntity)be).isActive()) {
            g.applyCollisionPing((LivingEntity)entity);
        }
    }
}

