/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.concurrent.ThreadLocalRandom;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.particle.ModParticleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class InfusedFarmlandBlock
extends FarmBlock {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public InfusedFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() instanceof ShovelItem && state.getBlock() == ModBlocks.INFUSED_FARMLAND.get() && hitResult.getDirection() != Direction.DOWN && level.getBlockState(pos.above()).isAir()) {
            level.playSound(player, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (level.isClientSide) {
                level.setBlockAndUpdate(pos, ((Block)ModBlocks.INFUSED_DIRT.get()).defaultBlockState());
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.getBlockState(pos.above());
        return super.canSurvive(state, level, pos) || aboveState.getBlock() instanceof StemBlock;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            this.setToInfusedDirt(level, pos);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BonemealableBlock growable;
        BlockPos cropPos = pos.above();
        if (!(level.isRaining() && level.canSeeSky(cropPos) && ((Biome)level.getBiome(cropPos).value()).hasPrecipitation())) {
            return;
        }
        BlockState cropState = level.getBlockState(cropPos);
        Block block = cropState.getBlock();
        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, cropPos, cropState) && growable.isBonemealSuccess((Level)level, random, cropPos, cropState)) {
            growable.performBonemeal(level, random, cropPos, cropState);
            level.levelEvent(1505, cropPos, 0);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, cropPos);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? ((Block)ModBlocks.INFUSED_DIRT.get()).defaultBlockState() : super.getStateForPlacement(context);
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPos, Direction facing, BlockState plantState) {
        if (plantState.is(BlockTags.CROPS)) {
            return TriState.TRUE;
        }
        if (plantState.is(BlockTags.FLOWERS)) {
            return TriState.TRUE;
        }
        return super.canSustainPlant(state, level, soilPos, facing, plantState);
    }

    private void setToInfusedDirt(ServerLevel level, BlockPos pos) {
        level.setBlockAndUpdate(pos, InfusedFarmlandBlock.pushEntitiesUp((BlockState)level.getBlockState(pos), (BlockState)((Block)ModBlocks.INFUSED_DIRT.get()).defaultBlockState(), (LevelAccessor)level, (BlockPos)pos));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        this.spawnBubblesParticles(level, pos);
    }

    private void spawnBubblesParticles(Level level, BlockPos pos) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 8; ++i) {
            double x = (double)pos.getX() + 0.5 + random.nextDouble(-0.5, 0.5);
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5 + random.nextDouble(-0.5, 0.5);
            level.addParticle((ParticleOptions)ModParticleType.INFUSED_BUBBLES.get(), x, y, z, 0.0, 0.05, 0.0);
        }
    }
}

