/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.Optional;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.EnchantedPlantBlock;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.MutationRecipe;
import net.astralya.hexalia.recipe.MutationRecipeInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MorphoraBlock
extends EnchantedPlantBlock {
    public MorphoraBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(Blocks.MAGMA_BLOCK) || state.isSolid();
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.isEmpty() || stack.getItem() != ModItems.MUTAVIS.get()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        ServerLevel server = (ServerLevel)level;
        boolean anyConverted = false;
        int radius = (Integer)Configuration.MORPHORA_RADIUS.get();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                Optional<MutationRecipe> match;
                ItemStack inputStack;
                BlockState targetState;
                BlockPos targetPos = pos.offset(dx, 0, dz);
                if (targetPos.equals((Object)pos) || (targetState = server.getBlockState(targetPos)).isAir() || (inputStack = targetState.getBlock().asItem().getDefaultInstance()).isEmpty() || !(match = server.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.MUTATION_TYPE.get(), (RecipeInput)new MutationRecipeInput(inputStack), (Level)server).map(RecipeHolder::value)).isPresent()) continue;
                ItemStack result = match.get().assemble(new MutationRecipeInput(inputStack), (HolderLookup.Provider)server.registryAccess());
                server.destroyBlock(targetPos, false);
                if (!result.isEmpty()) {
                    server.addFreshEntity((Entity)new ItemEntity((Level)server, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.25, (double)targetPos.getZ() + 0.5, result.copy()));
                }
                this.emitEffects(server, targetPos);
                anyConverted = true;
            }
        }
        if (anyConverted) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void emitEffects(ServerLevel server, BlockPos pos) {
        server.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.5f, 1.0f);
        server.sendParticles((ParticleOptions)ModParticleType.LEAVES.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 15, 0.2, 0.25, 0.2, 0.0);
    }
}

