/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WildSunfireTomatoBlock
extends BushBlock {
    public static final MapCodec<WildSunfireTomatoBlock> CODEC = WildSunfireTomatoBlock.simpleCodec(WildSunfireTomatoBlock::new);
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), (VoxelShape[])new VoxelShape[0]);

    public MapCodec<WildSunfireTomatoBlock> codec() {
        return CODEC;
    }

    public WildSunfireTomatoBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.spawnFireParticles(level, pos);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void entityInside(BlockState pState, Level pLevel, BlockPos pos, Entity pEntity) {
        LivingEntity livingEntity;
        if (!pLevel.isClientSide && pLevel.getDifficulty() != Difficulty.PEACEFUL && pEntity instanceof LivingEntity && !(livingEntity = (LivingEntity)pEntity).isSteppingCarefully() && !livingEntity.fireImmune()) {
            Player player;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
                return;
            }
            livingEntity.igniteForSeconds(5.0f);
        }
    }

    private void spawnFireParticles(Level level, BlockPos pos) {
        double maxHorizontalOffset = 0.5;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 8; ++i) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + random.nextDouble(0.33);
            double z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x += random.nextDouble(-0.5, 0.5), y, z += random.nextDouble(-0.5, 0.5), 0.0, 0.05, 0.0);
        }
    }
}

