/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom.censer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CenserEffectHandler {
    private static final Map<Level, Set<BlockPos>> UNDEAD_VEIL_CACHE = new WeakHashMap<Level, Set<BlockPos>>();
    private static final int MINERS_RESPITE_EFFECT_REFRESH_TICKS = 300;
    public static final Map<HerbCombination, BiConsumer<Level, BlockPos>> EFFECTS = Map.of(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()), CenserEffectHandler::applyFireproofPresence, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).asItem(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()), CenserEffectHandler::applyUndeadVeil, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).asItem(), (Item)ModItems.SIREN_KELP.get()), CenserEffectHandler::applyLivestockComfort, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()), CenserEffectHandler::applyMinersRespite, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), (Item)ModItems.SIREN_KELP.get()), CenserEffectHandler::applyFishersBoon, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), ((Block)ModBlocks.GHOST_FERN.get()).asItem()), CenserEffectHandler::applySuctionZone);
    private static final Map<BlockPos, ActiveCenserEffect> ACTIVE_EFFECTS = new HashMap<BlockPos, ActiveCenserEffect>();

    public static void registerActiveEffect(Level level, BlockPos pos, HerbCombination combo, int remainingTime) {
        if (level.isClientSide()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, remainingTime, combo));
        CenserEffectHandler.applyEffects(level, pos, combo);
        if (CenserEffectHandler.getEffectTypeForCombination(combo) == EffectType.UNDEAD_VEIL) {
            UNDEAD_VEIL_CACHE.computeIfAbsent(level, k -> new HashSet()).add(pos.immutable());
        }
    }

    public static void removeActiveEffect(BlockPos pos) {
        EffectType effectType;
        ActiveCenserEffect effect = ACTIVE_EFFECTS.get(pos);
        if (effect != null && (effectType = CenserEffectHandler.getEffectTypeForCombination(effect.combo())) == EffectType.UNDEAD_VEIL) {
            for (Map.Entry<Level, Set<BlockPos>> entry : UNDEAD_VEIL_CACHE.entrySet()) {
                if (entry.getValue().remove(pos)) break;
            }
        }
        ACTIVE_EFFECTS.remove(pos);
    }

    public static void startEffect(Level level, BlockPos pos, HerbCombination combo) {
        if (level.isClientSide()) {
            return;
        }
        int duration = (Integer)Configuration.CENSER_EFFECT_DURATION.get();
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, duration, combo));
        if (CenserEffectHandler.getEffectTypeForCombination(combo) == EffectType.MINERS_RESPITE && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            CenserEffectHandler.repairAnvilsInArea(sl, pos, (Integer)Configuration.CENSER_EFFECT_RADIUS.get());
        }
        CenserEffectHandler.applyEffects(level, pos, combo);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CenserBlockEntity) {
            CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
            censer.setActiveCombination(combo);
            censer.setBurnTime(duration);
        }
    }

    public static void updateEffects(Level level) {
        Iterator<Map.Entry<BlockPos, ActiveCenserEffect>> it = ACTIVE_EFFECTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, ActiveCenserEffect> entry = it.next();
            BlockPos pos = entry.getKey();
            ActiveCenserEffect effect = entry.getValue();
            effect.decrementDuration();
            if (effect.isExpired()) {
                CenserEffectHandler.clearEffect(level, pos, effect.combo());
                it.remove();
                continue;
            }
            CenserEffectHandler.applyEffects(level, pos, effect.combo());
        }
    }

    private static void clearEffect(Level level, BlockPos pos, HerbCombination combo) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).inflate((double)radius);
        level.getEntitiesOfClass(Player.class, area).forEach(player -> player.getPersistentData().remove("HexaliaFishersBoon"));
    }

    public static void applyEffects(Level level, BlockPos pos, HerbCombination combo) {
        if (level.isClientSide()) {
            return;
        }
        EFFECTS.getOrDefault(combo, (l, p) -> {}).accept(level, pos);
    }

    public static boolean isValidCombination(Item item1, Item item2) {
        HerbCombination combo = new HerbCombination(item1, item2);
        return EFFECTS.containsKey(combo);
    }

    public static void clearPlayerEffectsInRange(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).inflate((double)radius);
        level.getEntitiesOfClass(Player.class, area).forEach(player -> {
            player.getPersistentData().remove("HexaliaAnvilHarmony");
            player.getPersistentData().remove("HexaliaFishersBoon");
        });
    }

    public static boolean isUndeadVeilActiveInArea(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        if (level.isClientSide()) {
            return false;
        }
        Set<BlockPos> veilPositions = UNDEAD_VEIL_CACHE.get(level);
        if (veilPositions == null || veilPositions.isEmpty()) {
            return false;
        }
        double radiusSquared = radius * radius;
        for (BlockPos center : veilPositions) {
            if (!(pos.distSqr((Vec3i)center) <= radiusSquared)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEffectActiveInArea(Level level, BlockPos pos, EffectType effectType) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        if (effectType == EffectType.UNDEAD_VEIL) {
            return CenserEffectHandler.isUndeadVeilActiveInArea(level, pos);
        }
        AABB area = new AABB(pos).inflate((double)radius);
        return BlockPos.betweenClosedStream((BlockPos)BlockPos.containing((double)area.minX, (double)area.minY, (double)area.minZ), (BlockPos)BlockPos.containing((double)area.maxX, (double)area.maxY, (double)area.maxZ)).map(arg_0 -> ((Level)level).getBlockEntity(arg_0)).filter(be -> be instanceof CenserBlockEntity).map(be -> (CenserBlockEntity)((Object)be)).anyMatch(censer -> {
            if (!((Boolean)censer.getBlockState().getValue((Property)CenserBlock.LIT)).booleanValue()) {
                return false;
            }
            ItemStack herb1 = censer.getItem(0);
            ItemStack herb2 = censer.getItem(1);
            if (herb1.isEmpty() || herb2.isEmpty()) {
                return false;
            }
            return CenserEffectHandler.getEffectTypeForCombination(new HerbCombination(herb1.getItem(), herb2.getItem())) == effectType;
        });
    }

    private static void applyFireproofPresence(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).inflate((double)radius);
        level.getEntitiesOfClass(LivingEntity.class, area).forEach(entity -> {
            entity.setRemainingFireTicks(0);
            entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 100, 0, false, false, true));
        });
    }

    private static void applyUndeadVeil(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).inflate((double)radius);
        level.getEntitiesOfClass(Mob.class, area, e -> e instanceof Monster && e.getClassification(false) == MobCategory.MONSTER).forEach(mob -> {
            mob.setTarget(null);
            mob.setLastHurtByMob(null);
            mob.setLastHurtByPlayer(null);
            if (mob instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)mob;
                neutralMob.setPersistentAngerTarget(null);
                neutralMob.stopBeingAngry();
            }
            if (!mob.hasEffect(MobEffects.GLOWING)) {
                mob.addEffect(new MobEffectInstance(MobEffects.GLOWING, 140, 0, false, false));
            }
            mob.setNoActionTime(40);
        });
    }

    private static void applyLivestockComfort(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).inflate((double)radius);
        level.getEntitiesOfClass(Animal.class, area).forEach(animal -> {
            if (animal.getAge() < 0) {
                animal.ageUp((int)((double)animal.getAge() * 0.5), true);
            }
        });
    }

    private static void applyMinersRespite(Level level, BlockPos censerPos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(censerPos).inflate((double)radius);
        serverLevel.getEntitiesOfClass(Player.class, area).forEach(player -> {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0, false, false, true));
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 300, 1, false, false, true));
        });
    }

    private static void repairAnvilsInArea(ServerLevel level, BlockPos center, int radius) {
        AABB area = new AABB(center).inflate((double)radius);
        BlockPos min = BlockPos.containing((double)area.minX, (double)area.minY, (double)area.minZ);
        BlockPos max = BlockPos.containing((double)area.maxX, (double)area.maxY, (double)area.maxZ);
        for (BlockPos bp : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
            BlockState state = level.getBlockState(bp);
            if (!(state.getBlock() instanceof AnvilBlock)) continue;
            Direction facing = state.hasProperty((Property)AnvilBlock.FACING) ? (Direction)state.getValue((Property)AnvilBlock.FACING) : Direction.NORTH;
            BlockState repaired = null;
            if (state.is(Blocks.DAMAGED_ANVIL)) {
                repaired = Blocks.CHIPPED_ANVIL.defaultBlockState();
            } else if (state.is(Blocks.CHIPPED_ANVIL)) {
                repaired = Blocks.ANVIL.defaultBlockState();
            }
            if (repaired == null) continue;
            if (repaired.hasProperty((Property)AnvilBlock.FACING)) {
                repaired = (BlockState)repaired.setValue((Property)AnvilBlock.FACING, (Comparable)facing);
            }
            level.setBlock(bp, repaired, 3);
            level.playSound(null, bp, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.35f, 1.2f);
            level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)bp.getX() + 0.5, (double)bp.getY() + 1.0, (double)bp.getZ() + 0.5, 3, 0.25, 0.15, 0.25, 0.0);
        }
    }

    private static void applyFishersBoon(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        level.getEntitiesOfClass(Player.class, new AABB(pos).inflate((double)radius)).forEach(player -> player.getPersistentData().putBoolean("HexaliaFishersBoon", true));
    }

    private static void applySuctionZone(Level level, BlockPos pos) {
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB area = new AABB(pos).inflate((double)radius);
        List items = serverLevel.getEntitiesOfClass(ItemEntity.class, area);
        if (items.isEmpty()) {
            return;
        }
        List<HopperBlockEntity> hoppers = BlockPos.betweenClosedStream((BlockPos)BlockPos.containing((double)area.minX, (double)area.minY, (double)area.minZ), (BlockPos)BlockPos.containing((double)area.maxX, (double)area.maxY, (double)area.maxZ)).map(arg_0 -> ((ServerLevel)serverLevel).getBlockEntity(arg_0)).filter(be -> be instanceof HopperBlockEntity).map(be -> (HopperBlockEntity)be).toList();
        for (ItemEntity item : items) {
            if (item.isRemoved()) continue;
            Vec3 itemPos = item.position();
            boolean itemAbsorbed = false;
            if (!hoppers.isEmpty()) {
                for (HopperBlockEntity hopper : hoppers) {
                    ItemStack remaining = HopperBlockEntity.addItem(null, (Container)hopper, (ItemStack)item.getItem().copy(), null);
                    if (remaining.isEmpty()) {
                        itemAbsorbed = true;
                        break;
                    }
                    if (remaining.getCount() >= item.getItem().getCount()) continue;
                    item.setItem(remaining);
                    CenserEffectHandler.playSuctionEffects(serverLevel, itemPos);
                }
            } else {
                Player nearestPlayer = (Player)CenserEffectHandler.findNearestEntity(itemPos, serverLevel.getEntitiesOfClass(Player.class, area));
                if (nearestPlayer != null) {
                    item.playerTouch(nearestPlayer);
                }
            }
            if (!itemAbsorbed) continue;
            CenserEffectHandler.playSuctionEffects(serverLevel, itemPos);
            item.discard();
        }
    }

    private static void playSuctionEffects(ServerLevel level, Vec3 pos) {
        level.playSound(null, pos.x, pos.y, pos.z, (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
        for (int i = 0; i < 8; ++i) {
            double angle = level.random.nextDouble() * 2.0 * Math.PI;
            double radius = level.random.nextDouble() * 0.5;
            double x = pos.x + radius * Math.cos(angle);
            double z = pos.z + radius * Math.sin(angle);
            double y = pos.y + level.random.nextDouble() * 0.5;
            level.sendParticles((ParticleOptions)ParticleTypes.EFFECT, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static <T extends Entity> T findNearestEntity(Vec3 position, List<T> entities) {
        Entity nearest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distance = position.distanceToSqr(entity.position());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            nearest = entity;
        }
        return (T)nearest;
    }

    private static EffectType getEffectTypeForCombination(HerbCombination combo) {
        Map<HerbCombination, EffectType> combinationToEffect = Map.of(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()), EffectType.FIREPROOF_PRESENCE, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).asItem(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()), EffectType.UNDEAD_VEIL, new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).asItem(), (Item)ModItems.SIREN_KELP.get()), EffectType.LIVESTOCK_COMFORT, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()), EffectType.MINERS_RESPITE, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), (Item)ModItems.SIREN_KELP.get()), EffectType.FISHERS_BOON, new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), ((Block)ModBlocks.GHOST_FERN.get()).asItem()), EffectType.SUCTION_ZONE);
        return combinationToEffect.getOrDefault(combo, null);
    }

    public static String getMessageKeyForCombination(HerbCombination combo) {
        if (combo.equals(new HerbCombination((Item)ModItems.SIREN_KELP.get(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()))) {
            return "message.hexalia.censer.fireproof_presence";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).asItem(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()))) {
            return "message.hexalia.censer.undead_veil";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.GHOST_FERN.get()).asItem(), (Item)ModItems.SIREN_KELP.get()))) {
            return "message.hexalia.censer.livestock_comfort";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), ((Block)ModBlocks.SPIRIT_BLOOM.get()).asItem()))) {
            return "message.hexalia.censer.miners_respite";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), (Item)ModItems.SIREN_KELP.get()))) {
            return "message.hexalia.censer.fishers_boon";
        }
        if (combo.equals(new HerbCombination(((Block)ModBlocks.DREAMSHROOM.get()).asItem(), ((Block)ModBlocks.GHOST_FERN.get()).asItem()))) {
            return "message.hexalia.censer.suction_zone";
        }
        return "message.hexalia.censer.generic_effect";
    }

    private static class ActiveCenserEffect {
        private final EffectType type;
        private int duration;
        private final HerbCombination combo;

        public ActiveCenserEffect(EffectType type, int duration, HerbCombination combo) {
            this.type = type;
            this.duration = duration;
            this.combo = combo;
        }

        public void decrementDuration() {
            --this.duration;
        }

        public boolean isExpired() {
            return this.duration <= 0;
        }

        public HerbCombination combo() {
            return this.combo;
        }
    }

    public static enum EffectType {
        FIREPROOF_PRESENCE,
        UNDEAD_VEIL,
        LIVESTOCK_COMFORT,
        MINERS_RESPITE,
        FISHERS_BOON,
        SUCTION_ZONE;

    }
}

