/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ShelfBlockEntity
extends SyncBlockEntity {
    private static final int SIZE = 6;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);

    public ShelfBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypes.SHELF.get(), pos, blockState);
    }

    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= 6) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.items.get(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 6) {
            return;
        }
        this.items.set(slot, (Object)stack);
        this.setChanged();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.level != null && !this.level.isClientSide()) {
            Packet<ClientGamePacketListener> updatePacket = this.getUpdatePacket();
            for (ServerPlayer player : ModUtil.tracking((ServerLevel)this.level, this.worldPosition)) {
                player.connection.send(updatePacket);
            }
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack removeStack(int slot) {
        if (slot < 0 || slot >= 6) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ((ItemStack)this.items.get(slot)).copy();
        this.items.set(slot, (Object)ItemStack.EMPTY);
        this.setChanged();
        this.sendUpdate();
        return stack;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        for (ItemStack stack : this.items) {
            if (stack.isEmpty() || stack.getCount() > 0 && stack.getCount() <= stack.getMaxStackSize()) continue;
            stack.setCount(1);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

