/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.astralya.hexalia.block.custom.CenserBlock;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CenserBlockEntityRenderer
implements BlockEntityRenderer<CenserBlockEntity> {
    private final ItemRenderer itemRenderer;
    private static final float ITEM_SCALE = 0.75f;
    private static final float BASE_Y_OFFSET = 0.385f;
    private static final float ITEM_SPACING = 0.02f;

    public CenserBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(CenserBlockEntity censer, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = censer.getLevel();
        if (level == null) {
            return;
        }
        BlockState state = censer.getBlockState();
        if (state.hasProperty((Property)CenserBlock.LIT) && ((Boolean)state.getValue((Property)CenserBlock.LIT)).booleanValue()) {
            return;
        }
        NonNullList<ItemStack> items = censer.getItems();
        boolean hasItems = false;
        for (ItemStack stack : items) {
            if (stack.isEmpty()) continue;
            hasItems = true;
            break;
        }
        if (!hasItems) {
            return;
        }
        if (censer.getBurnTime() > 0) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)CenserBlock.FACING);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
        float currentY = 0.385f;
        float itemX = 0.0f;
        float itemZ = -0.0625f;
        for (ItemStack stack : items) {
            if (stack.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(itemX, currentY, itemZ);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.scale(0.75f, 0.75f, 0.75f);
            this.itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, buffer, level, (int)censer.getBlockPos().asLong());
            poseStack.popPose();
            currentY += 0.02f;
        }
        poseStack.popPose();
    }
}

